/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.RestoreDBInstanceToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class RestoreDBInstanceToPointInTimeRequestMarshaller
implements Marshaller<Request<RestoreDBInstanceToPointInTimeRequest>, RestoreDBInstanceToPointInTimeRequest> {
    public Request<RestoreDBInstanceToPointInTimeRequest> marshall(RestoreDBInstanceToPointInTimeRequest restoreDBInstanceToPointInTimeRequest) {
        SdkInternalList tagsList;
        if (restoreDBInstanceToPointInTimeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreDBInstanceToPointInTimeRequest, "RDSClient");
        request.addParameter("Action", "RestoreDBInstanceToPointInTime");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDBInstanceToPointInTimeRequest.sourceDBInstanceIdentifier() != null) {
            request.addParameter("SourceDBInstanceIdentifier", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.sourceDBInstanceIdentifier()));
        }
        if (restoreDBInstanceToPointInTimeRequest.targetDBInstanceIdentifier() != null) {
            request.addParameter("TargetDBInstanceIdentifier", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.targetDBInstanceIdentifier()));
        }
        if (restoreDBInstanceToPointInTimeRequest.restoreTime() != null) {
            request.addParameter("RestoreTime", StringUtils.fromDate((Date)restoreDBInstanceToPointInTimeRequest.restoreTime()));
        }
        if (restoreDBInstanceToPointInTimeRequest.useLatestRestorableTime() != null) {
            request.addParameter("UseLatestRestorableTime", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.useLatestRestorableTime()));
        }
        if (restoreDBInstanceToPointInTimeRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.dbInstanceClass()));
        }
        if (restoreDBInstanceToPointInTimeRequest.port() != null) {
            request.addParameter("Port", StringUtils.fromInteger((Integer)restoreDBInstanceToPointInTimeRequest.port()));
        }
        if (restoreDBInstanceToPointInTimeRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.availabilityZone()));
        }
        if (restoreDBInstanceToPointInTimeRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.dbSubnetGroupName()));
        }
        if (restoreDBInstanceToPointInTimeRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.multiAZ()));
        }
        if (restoreDBInstanceToPointInTimeRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.publiclyAccessible()));
        }
        if (restoreDBInstanceToPointInTimeRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.autoMinorVersionUpgrade()));
        }
        if (restoreDBInstanceToPointInTimeRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.licenseModel()));
        }
        if (restoreDBInstanceToPointInTimeRequest.dbName() != null) {
            request.addParameter("DBName", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.dbName()));
        }
        if (restoreDBInstanceToPointInTimeRequest.engine() != null) {
            request.addParameter("Engine", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.engine()));
        }
        if (restoreDBInstanceToPointInTimeRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)restoreDBInstanceToPointInTimeRequest.iops()));
        }
        if (restoreDBInstanceToPointInTimeRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.optionGroupName()));
        }
        if (restoreDBInstanceToPointInTimeRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.copyTagsToSnapshot()));
        }
        if (!(tagsList = (SdkInternalList)restoreDBInstanceToPointInTimeRequest.tags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDBInstanceToPointInTimeRequest.storageType() != null) {
            request.addParameter("StorageType", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.storageType()));
        }
        if (restoreDBInstanceToPointInTimeRequest.tdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.tdeCredentialArn()));
        }
        if (restoreDBInstanceToPointInTimeRequest.tdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.tdeCredentialPassword()));
        }
        if (restoreDBInstanceToPointInTimeRequest.domain() != null) {
            request.addParameter("Domain", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.domain()));
        }
        if (restoreDBInstanceToPointInTimeRequest.domainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString((String)restoreDBInstanceToPointInTimeRequest.domainIAMRoleName()));
        }
        if (restoreDBInstanceToPointInTimeRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean((Boolean)restoreDBInstanceToPointInTimeRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

