/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.rds.model.Parameter;
import software.amazon.awssdk.services.rds.model.ParametersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EngineDefaults
implements ToCopyableBuilder<Builder, EngineDefaults> {
    private final String dbParameterGroupFamily;
    private final String marker;
    private final List<Parameter> parameters;

    private EngineDefaults(BuilderImpl builder) {
        this.dbParameterGroupFamily = builder.dbParameterGroupFamily;
        this.marker = builder.marker;
        this.parameters = builder.parameters;
    }

    public String dbParameterGroupFamily() {
        return this.dbParameterGroupFamily;
    }

    public String marker() {
        return this.marker;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EngineDefaults)) {
            return false;
        }
        EngineDefaults other = (EngineDefaults)obj;
        return Objects.equals(this.dbParameterGroupFamily(), other.dbParameterGroupFamily()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"EngineDefaults").add("DBParameterGroupFamily", (Object)this.dbParameterGroupFamily()).add("Marker", (Object)this.marker()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBParameterGroupFamily": {
                return Optional.of(clazz.cast(this.dbParameterGroupFamily()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dbParameterGroupFamily;
        private String marker;
        private List<Parameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(EngineDefaults model) {
            this.dbParameterGroupFamily(model.dbParameterGroupFamily);
            this.marker(model.marker);
            this.parameters(model.parameters);
        }

        public final String getDBParameterGroupFamily() {
            return this.dbParameterGroupFamily;
        }

        @Override
        public final Builder dbParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
            return this;
        }

        public final void setDBParameterGroupFamily(String dbParameterGroupFamily) {
            this.dbParameterGroupFamily = dbParameterGroupFamily;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        public EngineDefaults build() {
            return new EngineDefaults(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EngineDefaults> {
        public Builder dbParameterGroupFamily(String var1);

        public Builder marker(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);
    }
}

