/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.rds.RDSClient;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.DescribeDBSubnetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBSubnetGroupsResponse;

public class DescribeDBSubnetGroupsIterable
implements SdkIterable<DescribeDBSubnetGroupsResponse> {
    private final RDSClient client;
    private final DescribeDBSubnetGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBSubnetGroupsIterable(RDSClient client, DescribeDBSubnetGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDBSubnetGroupsResponseFetcher();
    }

    public Iterator<DescribeDBSubnetGroupsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<DBSubnetGroup> dbSubnetGroups() {
        Function<DescribeDBSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSubnetGroups() != null) {
                return response.dbSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeDBSubnetGroupsIterable resume(DescribeDBSubnetGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBSubnetGroupsIterable(this.client, (DescribeDBSubnetGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBSubnetGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDBSubnetGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDBSubnetGroupsResponseFetcher
    implements SyncPageFetcher<DescribeDBSubnetGroupsResponse> {
        private DescribeDBSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBSubnetGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeDBSubnetGroupsResponse nextPage(DescribeDBSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSubnetGroupsIterable.this.client.describeDBSubnetGroups(DescribeDBSubnetGroupsIterable.this.firstRequest);
            }
            return DescribeDBSubnetGroupsIterable.this.client.describeDBSubnetGroups((DescribeDBSubnetGroupsRequest)((Object)DescribeDBSubnetGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

