/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.rds.RDSAsyncClient;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.DescribeDBSubnetGroupsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDBSubnetGroupsResponse;

public class DescribeDBSubnetGroupsPublisher
implements SdkPublisher<DescribeDBSubnetGroupsResponse> {
    private final RDSAsyncClient client;
    private final DescribeDBSubnetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBSubnetGroupsPublisher(RDSAsyncClient client, DescribeDBSubnetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBSubnetGroupsPublisher(RDSAsyncClient client, DescribeDBSubnetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDBSubnetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDBSubnetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<DBSubnetGroup> dbSubnetGroups() {
        Function<DescribeDBSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbSubnetGroups() != null) {
                return response.dbSubnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeDBSubnetGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeDBSubnetGroupsPublisher resume(DescribeDBSubnetGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBSubnetGroupsPublisher(this.client, (DescribeDBSubnetGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBSubnetGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDBSubnetGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDBSubnetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeDBSubnetGroupsResponse> {
        private DescribeDBSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDBSubnetGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeDBSubnetGroupsResponse> nextPage(DescribeDBSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBSubnetGroupsPublisher.this.client.describeDBSubnetGroups(DescribeDBSubnetGroupsPublisher.this.firstRequest);
            }
            return DescribeDBSubnetGroupsPublisher.this.client.describeDBSubnetGroups((DescribeDBSubnetGroupsRequest)((Object)DescribeDBSubnetGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

