/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeOptionGroupsRequestMarshaller
implements Marshaller<Request<DescribeOptionGroupsRequest>, DescribeOptionGroupsRequest> {
    public Request<DescribeOptionGroupsRequest> marshall(DescribeOptionGroupsRequest describeOptionGroupsRequest) {
        List<Filter> filtersList;
        if (describeOptionGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeOptionGroupsRequest, "RDSClient");
        request.addParameter("Action", "DescribeOptionGroups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOptionGroupsRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString((String)describeOptionGroupsRequest.optionGroupName()));
        }
        if ((filtersList = describeOptionGroupsRequest.filters()) != null) {
            if (!filtersList.isEmpty()) {
                int filtersListIndex = 1;
                for (Filter filtersListValue : filtersList) {
                    List<String> valuesList;
                    if (filtersListValue.name() != null) {
                        request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.name()));
                    }
                    if ((valuesList = filtersListValue.values()) != null) {
                        if (!valuesList.isEmpty()) {
                            int valuesListIndex = 1;
                            for (String valuesListValue : valuesList) {
                                if (valuesListValue != null) {
                                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                                }
                                ++valuesListIndex;
                            }
                        } else {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                        }
                    }
                    ++filtersListIndex;
                }
            } else {
                request.addParameter("Filters", "");
            }
        }
        if (describeOptionGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeOptionGroupsRequest.marker()));
        }
        if (describeOptionGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeOptionGroupsRequest.maxRecords()));
        }
        if (describeOptionGroupsRequest.engineName() != null) {
            request.addParameter("EngineName", StringUtils.fromString((String)describeOptionGroupsRequest.engineName()));
        }
        if (describeOptionGroupsRequest.majorEngineVersion() != null) {
            request.addParameter("MajorEngineVersion", StringUtils.fromString((String)describeOptionGroupsRequest.majorEngineVersion()));
        }
        return request;
    }
}

