/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBClusterParameterGroup;
import software.amazon.awssdk.services.rds.model.DBClusterParameterGroupListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbClusterParameterGroupsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbClusterParameterGroupsResponse> {
    private final String marker;
    private final List<DBClusterParameterGroup> dbClusterParameterGroups;

    private DescribeDbClusterParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterParameterGroups = builder.dbClusterParameterGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBClusterParameterGroup> dbClusterParameterGroups() {
        return this.dbClusterParameterGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterParameterGroupsResponse)) {
            return false;
        }
        DescribeDbClusterParameterGroupsResponse other = (DescribeDbClusterParameterGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbClusterParameterGroups(), other.dbClusterParameterGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbClusterParameterGroupsResponse").add("Marker", (Object)this.marker()).add("DBClusterParameterGroups", this.dbClusterParameterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBClusterParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterParameterGroup> dbClusterParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterParameterGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusterParameterGroups(model.dbClusterParameterGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBClusterParameterGroup.Builder> getDBClusterParameterGroups() {
            return this.dbClusterParameterGroups != null ? (Collection)this.dbClusterParameterGroups.stream().map(DBClusterParameterGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copy(dbClusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(DBClusterParameterGroup ... dbClusterParameterGroups) {
            this.dbClusterParameterGroups(Arrays.asList(dbClusterParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterParameterGroups(Consumer<DBClusterParameterGroup.Builder> ... dbClusterParameterGroups) {
            this.dbClusterParameterGroups(Stream.of(dbClusterParameterGroups).map(c -> (DBClusterParameterGroup)((DBClusterParameterGroup.Builder)DBClusterParameterGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDBClusterParameterGroups(Collection<DBClusterParameterGroup.BuilderImpl> dbClusterParameterGroups) {
            this.dbClusterParameterGroups = DBClusterParameterGroupListCopier.copyFromBuilder(dbClusterParameterGroups);
        }

        @Override
        public DescribeDbClusterParameterGroupsResponse build() {
            return new DescribeDbClusterParameterGroupsResponse(this);
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    CopyableBuilder<Builder, DescribeDbClusterParameterGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbClusterParameterGroups(Collection<DBClusterParameterGroup> var1);

        public Builder dbClusterParameterGroups(DBClusterParameterGroup ... var1);

        public Builder dbClusterParameterGroups(Consumer<DBClusterParameterGroup.Builder> ... var1);
    }
}

