/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.OrderableDBInstanceOption;
import software.amazon.awssdk.services.rds.model.OrderableDBInstanceOptionsListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrderableDbInstanceOptionsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeOrderableDbInstanceOptionsResponse> {
    private final List<OrderableDBInstanceOption> orderableDBInstanceOptions;
    private final String marker;

    private DescribeOrderableDbInstanceOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.orderableDBInstanceOptions = builder.orderableDBInstanceOptions;
        this.marker = builder.marker;
    }

    public List<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        return this.orderableDBInstanceOptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orderableDBInstanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableDbInstanceOptionsResponse)) {
            return false;
        }
        DescribeOrderableDbInstanceOptionsResponse other = (DescribeOrderableDbInstanceOptionsResponse)((Object)obj);
        return Objects.equals(this.orderableDBInstanceOptions(), other.orderableDBInstanceOptions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeOrderableDbInstanceOptionsResponse").add("OrderableDBInstanceOptions", this.orderableDBInstanceOptions()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderableDBInstanceOptions": {
                return Optional.ofNullable(clazz.cast(this.orderableDBInstanceOptions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<OrderableDBInstanceOption> orderableDBInstanceOptions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableDbInstanceOptionsResponse model) {
            super(model);
            this.orderableDBInstanceOptions(model.orderableDBInstanceOptions);
            this.marker(model.marker);
        }

        public final Collection<OrderableDBInstanceOption.Builder> getOrderableDBInstanceOptions() {
            return this.orderableDBInstanceOptions != null ? (Collection)this.orderableDBInstanceOptions.stream().map(OrderableDBInstanceOption::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copy(orderableDBInstanceOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableDBInstanceOptions(OrderableDBInstanceOption ... orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions(Arrays.asList(orderableDBInstanceOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableDBInstanceOptions(Consumer<OrderableDBInstanceOption.Builder> ... orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions(Stream.of(orderableDBInstanceOptions).map(c -> (OrderableDBInstanceOption)((OrderableDBInstanceOption.Builder)OrderableDBInstanceOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrderableDBInstanceOptions(Collection<OrderableDBInstanceOption.BuilderImpl> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copyFromBuilder(orderableDBInstanceOptions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeOrderableDbInstanceOptionsResponse build() {
            return new DescribeOrderableDbInstanceOptionsResponse(this);
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    CopyableBuilder<Builder, DescribeOrderableDbInstanceOptionsResponse> {
        public Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> var1);

        public Builder orderableDBInstanceOptions(OrderableDBInstanceOption ... var1);

        public Builder orderableDBInstanceOptions(Consumer<OrderableDBInstanceOption.Builder> ... var1);

        public Builder marker(String var1);
    }
}

