/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RebootDbInstanceRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, RebootDbInstanceRequest> {
    private final String dbInstanceIdentifier;
    private final Boolean forceFailover;

    private RebootDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.forceFailover = builder.forceFailover;
    }

    public String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public Boolean forceFailover() {
        return this.forceFailover;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.forceFailover());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RebootDbInstanceRequest)) {
            return false;
        }
        RebootDbInstanceRequest other = (RebootDbInstanceRequest)((Object)obj);
        return Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.forceFailover(), other.forceFailover());
    }

    public String toString() {
        return ToString.builder((String)"RebootDbInstanceRequest").add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("ForceFailover", (Object)this.forceFailover()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "ForceFailover": {
                return Optional.ofNullable(clazz.cast(this.forceFailover()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbInstanceIdentifier;
        private Boolean forceFailover;

        private BuilderImpl() {
        }

        private BuilderImpl(RebootDbInstanceRequest model) {
            super(model);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.forceFailover(model.forceFailover);
        }

        public final String getDBInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final void setDBInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        public final Boolean getForceFailover() {
            return this.forceFailover;
        }

        @Override
        public final Builder forceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
            return this;
        }

        public final void setForceFailover(Boolean forceFailover) {
            this.forceFailover = forceFailover;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RebootDbInstanceRequest build() {
            return new RebootDbInstanceRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, RebootDbInstanceRequest> {
        public Builder dbInstanceIdentifier(String var1);

        public Builder forceFailover(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

