/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Parameter;
import software.amazon.awssdk.services.rds.model.ParametersListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetDbParameterGroupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ResetDbParameterGroupRequest> {
    private final String dbParameterGroupName;
    private final Boolean resetAllParameters;
    private final List<Parameter> parameters;

    private ResetDbParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.resetAllParameters = builder.resetAllParameters;
        this.parameters = builder.parameters;
    }

    public String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public Boolean resetAllParameters() {
        return this.resetAllParameters;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resetAllParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetDbParameterGroupRequest)) {
            return false;
        }
        ResetDbParameterGroupRequest other = (ResetDbParameterGroupRequest)((Object)obj);
        return Objects.equals(this.dbParameterGroupName(), other.dbParameterGroupName()) && Objects.equals(this.resetAllParameters(), other.resetAllParameters()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        return ToString.builder((String)"ResetDbParameterGroupRequest").add("DBParameterGroupName", (Object)this.dbParameterGroupName()).add("ResetAllParameters", (Object)this.resetAllParameters()).add("Parameters", this.parameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupName()));
            }
            case "ResetAllParameters": {
                return Optional.ofNullable(clazz.cast(this.resetAllParameters()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbParameterGroupName;
        private Boolean resetAllParameters;
        private List<Parameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResetDbParameterGroupRequest model) {
            super(model);
            this.dbParameterGroupName(model.dbParameterGroupName);
            this.resetAllParameters(model.resetAllParameters);
            this.parameters(model.parameters);
        }

        public final String getDBParameterGroupName() {
            return this.dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final void setDBParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        public final Boolean getResetAllParameters() {
            return this.resetAllParameters;
        }

        @Override
        public final Builder resetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
            return this;
        }

        public final void setResetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<Parameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (Parameter)((Parameter.Builder)Parameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetDbParameterGroupRequest build() {
            return new ResetDbParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, ResetDbParameterGroupRequest> {
        public Builder dbParameterGroupName(String var1);

        public Builder resetAllParameters(Boolean var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder parameters(Consumer<Parameter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

