/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeDBLogFilesDetails;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbLogFilesResponse;

public class DescribeDBLogFilesPublisher
implements SdkPublisher<DescribeDbLogFilesResponse> {
    private final RdsAsyncClient client;
    private final DescribeDbLogFilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDBLogFilesPublisher(RdsAsyncClient client, DescribeDbLogFilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDBLogFilesPublisher(RdsAsyncClient client, DescribeDbLogFilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDbLogFilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDbLogFilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DescribeDBLogFilesDetails> describeDBLogFiles() {
        Function<DescribeDbLogFilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.describeDBLogFiles() != null) {
                return response.describeDBLogFiles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDbLogFilesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeDBLogFilesPublisher resume(DescribeDbLogFilesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBLogFilesPublisher(this.client, (DescribeDbLogFilesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBLogFilesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeDbLogFilesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeDbLogFilesResponseFetcher
    implements AsyncPageFetcher<DescribeDbLogFilesResponse> {
        private DescribeDbLogFilesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbLogFilesResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public CompletableFuture<DescribeDbLogFilesResponse> nextPage(DescribeDbLogFilesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBLogFilesPublisher.this.client.describeDBLogFiles(DescribeDBLogFilesPublisher.this.firstRequest);
            }
            return DescribeDBLogFilesPublisher.this.client.describeDBLogFiles((DescribeDbLogFilesRequest)((Object)DescribeDBLogFilesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

