/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersResponse;
import software.amazon.awssdk.services.rds.model.Parameter;

public class DescribeDBParametersIterable
implements SdkIterable<DescribeDbParametersResponse> {
    private final RdsClient client;
    private final DescribeDbParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBParametersIterable(RdsClient client, DescribeDbParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDbParametersResponseFetcher();
    }

    public Iterator<DescribeDbParametersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeDbParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeDBParametersIterable resume(DescribeDbParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDBParametersIterable(this.client, (DescribeDbParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeDBParametersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDbParametersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDbParametersResponseFetcher
    implements SyncPageFetcher<DescribeDbParametersResponse> {
        private DescribeDbParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbParametersResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public DescribeDbParametersResponse nextPage(DescribeDbParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBParametersIterable.this.client.describeDBParameters(DescribeDBParametersIterable.this.firstRequest);
            }
            return DescribeDBParametersIterable.this.client.describeDBParameters((DescribeDbParametersRequest)((Object)DescribeDBParametersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

