/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.AddSourceIdentifierToSubscriptionRequest;

public class AddSourceIdentifierToSubscriptionRequestMarshaller
implements Marshaller<Request<AddSourceIdentifierToSubscriptionRequest>, AddSourceIdentifierToSubscriptionRequest> {
    public Request<AddSourceIdentifierToSubscriptionRequest> marshall(AddSourceIdentifierToSubscriptionRequest addSourceIdentifierToSubscriptionRequest) {
        if (addSourceIdentifierToSubscriptionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)addSourceIdentifierToSubscriptionRequest, "RdsClient");
        request.addParameter("Action", "AddSourceIdentifierToSubscription");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (addSourceIdentifierToSubscriptionRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringConversion.fromString((String)addSourceIdentifierToSubscriptionRequest.subscriptionName()));
        }
        if (addSourceIdentifierToSubscriptionRequest.sourceIdentifier() != null) {
            request.addParameter("SourceIdentifier", StringConversion.fromString((String)addSourceIdentifierToSubscriptionRequest.sourceIdentifier()));
        }
        return request;
    }
}

