/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CopyOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CopyOptionGroupRequestMarshaller
implements Marshaller<Request<CopyOptionGroupRequest>, CopyOptionGroupRequest> {
    public Request<CopyOptionGroupRequest> marshall(CopyOptionGroupRequest copyOptionGroupRequest) {
        if (copyOptionGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)copyOptionGroupRequest, "RdsClient");
        request.addParameter("Action", "CopyOptionGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyOptionGroupRequest.sourceOptionGroupIdentifier() != null) {
            request.addParameter("SourceOptionGroupIdentifier", StringConversion.fromString((String)copyOptionGroupRequest.sourceOptionGroupIdentifier()));
        }
        if (copyOptionGroupRequest.targetOptionGroupIdentifier() != null) {
            request.addParameter("TargetOptionGroupIdentifier", StringConversion.fromString((String)copyOptionGroupRequest.targetOptionGroupIdentifier()));
        }
        if (copyOptionGroupRequest.targetOptionGroupDescription() != null) {
            request.addParameter("TargetOptionGroupDescription", StringConversion.fromString((String)copyOptionGroupRequest.targetOptionGroupDescription()));
        }
        if (copyOptionGroupRequest.tags().isEmpty() && !(copyOptionGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!copyOptionGroupRequest.tags().isEmpty() && !(copyOptionGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = copyOptionGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

