/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateDbInstanceReadReplicaRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDbInstanceReadReplicaRequestMarshaller
implements Marshaller<Request<CreateDbInstanceReadReplicaRequest>, CreateDbInstanceReadReplicaRequest> {
    public Request<CreateDbInstanceReadReplicaRequest> marshall(CreateDbInstanceReadReplicaRequest createDbInstanceReadReplicaRequest) {
        if (createDbInstanceReadReplicaRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createDbInstanceReadReplicaRequest, "RdsClient");
        request.addParameter("Action", "CreateDBInstanceReadReplica");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDbInstanceReadReplicaRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.dbInstanceIdentifier()));
        }
        if (createDbInstanceReadReplicaRequest.sourceDBInstanceIdentifier() != null) {
            request.addParameter("SourceDBInstanceIdentifier", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.sourceDBInstanceIdentifier()));
        }
        if (createDbInstanceReadReplicaRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.dbInstanceClass()));
        }
        if (createDbInstanceReadReplicaRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.availabilityZone()));
        }
        if (createDbInstanceReadReplicaRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)createDbInstanceReadReplicaRequest.port()));
        }
        if (createDbInstanceReadReplicaRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)createDbInstanceReadReplicaRequest.autoMinorVersionUpgrade()));
        }
        if (createDbInstanceReadReplicaRequest.iops() != null) {
            request.addParameter("Iops", StringConversion.fromInteger((Integer)createDbInstanceReadReplicaRequest.iops()));
        }
        if (createDbInstanceReadReplicaRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.optionGroupName()));
        }
        if (createDbInstanceReadReplicaRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringConversion.fromBoolean((Boolean)createDbInstanceReadReplicaRequest.publiclyAccessible()));
        }
        if (createDbInstanceReadReplicaRequest.tags().isEmpty() && !(createDbInstanceReadReplicaRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createDbInstanceReadReplicaRequest.tags().isEmpty() && !(createDbInstanceReadReplicaRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createDbInstanceReadReplicaRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createDbInstanceReadReplicaRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.dbSubnetGroupName()));
        }
        if (createDbInstanceReadReplicaRequest.storageType() != null) {
            request.addParameter("StorageType", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.storageType()));
        }
        if (createDbInstanceReadReplicaRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringConversion.fromBoolean((Boolean)createDbInstanceReadReplicaRequest.copyTagsToSnapshot()));
        }
        if (createDbInstanceReadReplicaRequest.monitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringConversion.fromInteger((Integer)createDbInstanceReadReplicaRequest.monitoringInterval()));
        }
        if (createDbInstanceReadReplicaRequest.monitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.monitoringRoleArn()));
        }
        if (createDbInstanceReadReplicaRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.kmsKeyId()));
        }
        if (createDbInstanceReadReplicaRequest.preSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.preSignedUrl()));
        }
        if (createDbInstanceReadReplicaRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)createDbInstanceReadReplicaRequest.enableIAMDatabaseAuthentication()));
        }
        if (createDbInstanceReadReplicaRequest.enablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringConversion.fromBoolean((Boolean)createDbInstanceReadReplicaRequest.enablePerformanceInsights()));
        }
        if (createDbInstanceReadReplicaRequest.performanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.performanceInsightsKMSKeyId()));
        }
        if (createDbInstanceReadReplicaRequest.sourceRegion() != null) {
            request.addParameter("SourceRegion", StringConversion.fromString((String)createDbInstanceReadReplicaRequest.sourceRegion()));
        }
        return request;
    }
}

