/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateEventSubscriptionRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateEventSubscriptionRequestMarshaller
implements Marshaller<Request<CreateEventSubscriptionRequest>, CreateEventSubscriptionRequest> {
    public Request<CreateEventSubscriptionRequest> marshall(CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        if (createEventSubscriptionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createEventSubscriptionRequest, "RdsClient");
        request.addParameter("Action", "CreateEventSubscription");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createEventSubscriptionRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringConversion.fromString((String)createEventSubscriptionRequest.subscriptionName()));
        }
        if (createEventSubscriptionRequest.snsTopicArn() != null) {
            request.addParameter("SnsTopicArn", StringConversion.fromString((String)createEventSubscriptionRequest.snsTopicArn()));
        }
        if (createEventSubscriptionRequest.sourceType() != null) {
            request.addParameter("SourceType", StringConversion.fromString((String)createEventSubscriptionRequest.sourceType()));
        }
        if (createEventSubscriptionRequest.eventCategories().isEmpty() && !(createEventSubscriptionRequest.eventCategories() instanceof SdkAutoConstructList)) {
            request.addParameter("EventCategories", "");
        } else if (!createEventSubscriptionRequest.eventCategories().isEmpty() && !(createEventSubscriptionRequest.eventCategories() instanceof SdkAutoConstructList)) {
            List<String> eventCategoriesList = createEventSubscriptionRequest.eventCategories();
            int eventCategoriesListIndex = 1;
            for (String eventCategoriesListValue : eventCategoriesList) {
                if (eventCategoriesListValue != null) {
                    request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringConversion.fromString((String)eventCategoriesListValue));
                }
                ++eventCategoriesListIndex;
            }
        }
        if (createEventSubscriptionRequest.sourceIds().isEmpty() && !(createEventSubscriptionRequest.sourceIds() instanceof SdkAutoConstructList)) {
            request.addParameter("SourceIds", "");
        } else if (!createEventSubscriptionRequest.sourceIds().isEmpty() && !(createEventSubscriptionRequest.sourceIds() instanceof SdkAutoConstructList)) {
            List<String> sourceIdsList = createEventSubscriptionRequest.sourceIds();
            int sourceIdsListIndex = 1;
            for (String sourceIdsListValue : sourceIdsList) {
                if (sourceIdsListValue != null) {
                    request.addParameter("SourceIds.SourceId." + sourceIdsListIndex, StringConversion.fromString((String)sourceIdsListValue));
                }
                ++sourceIdsListIndex;
            }
        }
        if (createEventSubscriptionRequest.enabled() != null) {
            request.addParameter("Enabled", StringConversion.fromBoolean((Boolean)createEventSubscriptionRequest.enabled()));
        }
        if (createEventSubscriptionRequest.tags().isEmpty() && !(createEventSubscriptionRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createEventSubscriptionRequest.tags().isEmpty() && !(createEventSubscriptionRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createEventSubscriptionRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

