/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateOptionGroupRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateOptionGroupRequestMarshaller
implements Marshaller<Request<CreateOptionGroupRequest>, CreateOptionGroupRequest> {
    public Request<CreateOptionGroupRequest> marshall(CreateOptionGroupRequest createOptionGroupRequest) {
        if (createOptionGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createOptionGroupRequest, "RdsClient");
        request.addParameter("Action", "CreateOptionGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createOptionGroupRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)createOptionGroupRequest.optionGroupName()));
        }
        if (createOptionGroupRequest.engineName() != null) {
            request.addParameter("EngineName", StringConversion.fromString((String)createOptionGroupRequest.engineName()));
        }
        if (createOptionGroupRequest.majorEngineVersion() != null) {
            request.addParameter("MajorEngineVersion", StringConversion.fromString((String)createOptionGroupRequest.majorEngineVersion()));
        }
        if (createOptionGroupRequest.optionGroupDescription() != null) {
            request.addParameter("OptionGroupDescription", StringConversion.fromString((String)createOptionGroupRequest.optionGroupDescription()));
        }
        if (createOptionGroupRequest.tags().isEmpty() && !(createOptionGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createOptionGroupRequest.tags().isEmpty() && !(createOptionGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createOptionGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

