/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeDbSubnetGroupsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeDbSubnetGroupsRequestMarshaller
implements Marshaller<Request<DescribeDbSubnetGroupsRequest>, DescribeDbSubnetGroupsRequest> {
    public Request<DescribeDbSubnetGroupsRequest> marshall(DescribeDbSubnetGroupsRequest describeDbSubnetGroupsRequest) {
        if (describeDbSubnetGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDbSubnetGroupsRequest, "RdsClient");
        request.addParameter("Action", "DescribeDBSubnetGroups");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDbSubnetGroupsRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)describeDbSubnetGroupsRequest.dbSubnetGroupName()));
        }
        if (describeDbSubnetGroupsRequest.filters().isEmpty() && !(describeDbSubnetGroupsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeDbSubnetGroupsRequest.filters().isEmpty() && !(describeDbSubnetGroupsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeDbSubnetGroupsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDbSubnetGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeDbSubnetGroupsRequest.maxRecords()));
        }
        if (describeDbSubnetGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeDbSubnetGroupsRequest.marker()));
        }
        return request;
    }
}

