/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeOrderableDbInstanceOptionsRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeOrderableDbInstanceOptionsRequestMarshaller
implements Marshaller<Request<DescribeOrderableDbInstanceOptionsRequest>, DescribeOrderableDbInstanceOptionsRequest> {
    public Request<DescribeOrderableDbInstanceOptionsRequest> marshall(DescribeOrderableDbInstanceOptionsRequest describeOrderableDbInstanceOptionsRequest) {
        if (describeOrderableDbInstanceOptionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeOrderableDbInstanceOptionsRequest, "RdsClient");
        request.addParameter("Action", "DescribeOrderableDBInstanceOptions");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeOrderableDbInstanceOptionsRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)describeOrderableDbInstanceOptionsRequest.engine()));
        }
        if (describeOrderableDbInstanceOptionsRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)describeOrderableDbInstanceOptionsRequest.engineVersion()));
        }
        if (describeOrderableDbInstanceOptionsRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringConversion.fromString((String)describeOrderableDbInstanceOptionsRequest.dbInstanceClass()));
        }
        if (describeOrderableDbInstanceOptionsRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringConversion.fromString((String)describeOrderableDbInstanceOptionsRequest.licenseModel()));
        }
        if (describeOrderableDbInstanceOptionsRequest.vpc() != null) {
            request.addParameter("Vpc", StringConversion.fromBoolean((Boolean)describeOrderableDbInstanceOptionsRequest.vpc()));
        }
        if (describeOrderableDbInstanceOptionsRequest.filters().isEmpty() && !(describeOrderableDbInstanceOptionsRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeOrderableDbInstanceOptionsRequest.filters().isEmpty() && !(describeOrderableDbInstanceOptionsRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeOrderableDbInstanceOptionsRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeOrderableDbInstanceOptionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeOrderableDbInstanceOptionsRequest.maxRecords()));
        }
        if (describeOrderableDbInstanceOptionsRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeOrderableDbInstanceOptionsRequest.marker()));
        }
        return request;
    }
}

