/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DownloadDbLogFilePortionRequest;

public class DownloadDbLogFilePortionRequestMarshaller
implements Marshaller<Request<DownloadDbLogFilePortionRequest>, DownloadDbLogFilePortionRequest> {
    public Request<DownloadDbLogFilePortionRequest> marshall(DownloadDbLogFilePortionRequest downloadDbLogFilePortionRequest) {
        if (downloadDbLogFilePortionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)downloadDbLogFilePortionRequest, "RdsClient");
        request.addParameter("Action", "DownloadDBLogFilePortion");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (downloadDbLogFilePortionRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)downloadDbLogFilePortionRequest.dbInstanceIdentifier()));
        }
        if (downloadDbLogFilePortionRequest.logFileName() != null) {
            request.addParameter("LogFileName", StringConversion.fromString((String)downloadDbLogFilePortionRequest.logFileName()));
        }
        if (downloadDbLogFilePortionRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)downloadDbLogFilePortionRequest.marker()));
        }
        if (downloadDbLogFilePortionRequest.numberOfLines() != null) {
            request.addParameter("NumberOfLines", StringConversion.fromInteger((Integer)downloadDbLogFilePortionRequest.numberOfLines()));
        }
        return request;
    }
}

