/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.ModifyDbClusterRequest;

public class ModifyDbClusterRequestMarshaller
implements Marshaller<Request<ModifyDbClusterRequest>, ModifyDbClusterRequest> {
    public Request<ModifyDbClusterRequest> marshall(ModifyDbClusterRequest modifyDbClusterRequest) {
        if (modifyDbClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyDbClusterRequest, "RdsClient");
        request.addParameter("Action", "ModifyDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDbClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)modifyDbClusterRequest.dbClusterIdentifier()));
        }
        if (modifyDbClusterRequest.newDBClusterIdentifier() != null) {
            request.addParameter("NewDBClusterIdentifier", StringConversion.fromString((String)modifyDbClusterRequest.newDBClusterIdentifier()));
        }
        if (modifyDbClusterRequest.applyImmediately() != null) {
            request.addParameter("ApplyImmediately", StringConversion.fromBoolean((Boolean)modifyDbClusterRequest.applyImmediately()));
        }
        if (modifyDbClusterRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringConversion.fromInteger((Integer)modifyDbClusterRequest.backupRetentionPeriod()));
        }
        if (modifyDbClusterRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringConversion.fromString((String)modifyDbClusterRequest.dbClusterParameterGroupName()));
        }
        if (modifyDbClusterRequest.vpcSecurityGroupIds().isEmpty() && !(modifyDbClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!modifyDbClusterRequest.vpcSecurityGroupIds().isEmpty() && !(modifyDbClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = modifyDbClusterRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (modifyDbClusterRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)modifyDbClusterRequest.port()));
        }
        if (modifyDbClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringConversion.fromString((String)modifyDbClusterRequest.masterUserPassword()));
        }
        if (modifyDbClusterRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)modifyDbClusterRequest.optionGroupName()));
        }
        if (modifyDbClusterRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringConversion.fromString((String)modifyDbClusterRequest.preferredBackupWindow()));
        }
        if (modifyDbClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)modifyDbClusterRequest.preferredMaintenanceWindow()));
        }
        if (modifyDbClusterRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)modifyDbClusterRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

