/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.PurchaseReservedDbInstancesOfferingRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class PurchaseReservedDbInstancesOfferingRequestMarshaller
implements Marshaller<Request<PurchaseReservedDbInstancesOfferingRequest>, PurchaseReservedDbInstancesOfferingRequest> {
    public Request<PurchaseReservedDbInstancesOfferingRequest> marshall(PurchaseReservedDbInstancesOfferingRequest purchaseReservedDbInstancesOfferingRequest) {
        if (purchaseReservedDbInstancesOfferingRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)purchaseReservedDbInstancesOfferingRequest, "RdsClient");
        request.addParameter("Action", "PurchaseReservedDBInstancesOffering");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (purchaseReservedDbInstancesOfferingRequest.reservedDBInstancesOfferingId() != null) {
            request.addParameter("ReservedDBInstancesOfferingId", StringConversion.fromString((String)purchaseReservedDbInstancesOfferingRequest.reservedDBInstancesOfferingId()));
        }
        if (purchaseReservedDbInstancesOfferingRequest.reservedDBInstanceId() != null) {
            request.addParameter("ReservedDBInstanceId", StringConversion.fromString((String)purchaseReservedDbInstancesOfferingRequest.reservedDBInstanceId()));
        }
        if (purchaseReservedDbInstancesOfferingRequest.dbInstanceCount() != null) {
            request.addParameter("DBInstanceCount", StringConversion.fromInteger((Integer)purchaseReservedDbInstancesOfferingRequest.dbInstanceCount()));
        }
        if (purchaseReservedDbInstancesOfferingRequest.tags().isEmpty() && !(purchaseReservedDbInstancesOfferingRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!purchaseReservedDbInstancesOfferingRequest.tags().isEmpty() && !(purchaseReservedDbInstancesOfferingRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = purchaseReservedDbInstancesOfferingRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

