/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromSnapshotRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDbClusterFromSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDbClusterFromSnapshotRequest>, RestoreDbClusterFromSnapshotRequest> {
    public Request<RestoreDbClusterFromSnapshotRequest> marshall(RestoreDbClusterFromSnapshotRequest restoreDbClusterFromSnapshotRequest) {
        if (restoreDbClusterFromSnapshotRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)restoreDbClusterFromSnapshotRequest, "RdsClient");
        request.addParameter("Action", "RestoreDBClusterFromSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDbClusterFromSnapshotRequest.availabilityZones().isEmpty() && !(restoreDbClusterFromSnapshotRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            request.addParameter("AvailabilityZones", "");
        } else if (!restoreDbClusterFromSnapshotRequest.availabilityZones().isEmpty() && !(restoreDbClusterFromSnapshotRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            List<String> availabilityZonesList = restoreDbClusterFromSnapshotRequest.availabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringConversion.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (restoreDbClusterFromSnapshotRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)restoreDbClusterFromSnapshotRequest.dbClusterIdentifier()));
        }
        if (restoreDbClusterFromSnapshotRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringConversion.fromString((String)restoreDbClusterFromSnapshotRequest.snapshotIdentifier()));
        }
        if (restoreDbClusterFromSnapshotRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)restoreDbClusterFromSnapshotRequest.engine()));
        }
        if (restoreDbClusterFromSnapshotRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)restoreDbClusterFromSnapshotRequest.engineVersion()));
        }
        if (restoreDbClusterFromSnapshotRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)restoreDbClusterFromSnapshotRequest.port()));
        }
        if (restoreDbClusterFromSnapshotRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)restoreDbClusterFromSnapshotRequest.dbSubnetGroupName()));
        }
        if (restoreDbClusterFromSnapshotRequest.databaseName() != null) {
            request.addParameter("DatabaseName", StringConversion.fromString((String)restoreDbClusterFromSnapshotRequest.databaseName()));
        }
        if (restoreDbClusterFromSnapshotRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)restoreDbClusterFromSnapshotRequest.optionGroupName()));
        }
        if (restoreDbClusterFromSnapshotRequest.vpcSecurityGroupIds().isEmpty() && !(restoreDbClusterFromSnapshotRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!restoreDbClusterFromSnapshotRequest.vpcSecurityGroupIds().isEmpty() && !(restoreDbClusterFromSnapshotRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = restoreDbClusterFromSnapshotRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (restoreDbClusterFromSnapshotRequest.tags().isEmpty() && !(restoreDbClusterFromSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!restoreDbClusterFromSnapshotRequest.tags().isEmpty() && !(restoreDbClusterFromSnapshotRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = restoreDbClusterFromSnapshotRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDbClusterFromSnapshotRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)restoreDbClusterFromSnapshotRequest.kmsKeyId()));
        }
        if (restoreDbClusterFromSnapshotRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)restoreDbClusterFromSnapshotRequest.enableIAMDatabaseAuthentication()));
        }
        return request;
    }
}

