/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.StopDbInstanceRequest;

public class StopDbInstanceRequestMarshaller
implements Marshaller<Request<StopDbInstanceRequest>, StopDbInstanceRequest> {
    public Request<StopDbInstanceRequest> marshall(StopDbInstanceRequest stopDbInstanceRequest) {
        if (stopDbInstanceRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)stopDbInstanceRequest, "RdsClient");
        request.addParameter("Action", "StopDBInstance");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (stopDbInstanceRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)stopDbInstanceRequest.dbInstanceIdentifier()));
        }
        if (stopDbInstanceRequest.dbSnapshotIdentifier() != null) {
            request.addParameter("DBSnapshotIdentifier", StringConversion.fromString((String)stopDbInstanceRequest.dbSnapshotIdentifier()));
        }
        return request;
    }
}

