/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CopyDbParameterGroupRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CopyDbParameterGroupRequest> {
    private final String sourceDBParameterGroupIdentifier;
    private final String targetDBParameterGroupIdentifier;
    private final String targetDBParameterGroupDescription;
    private final List<Tag> tags;

    private CopyDbParameterGroupRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBParameterGroupIdentifier = builder.sourceDBParameterGroupIdentifier;
        this.targetDBParameterGroupIdentifier = builder.targetDBParameterGroupIdentifier;
        this.targetDBParameterGroupDescription = builder.targetDBParameterGroupDescription;
        this.tags = builder.tags;
    }

    public String sourceDBParameterGroupIdentifier() {
        return this.sourceDBParameterGroupIdentifier;
    }

    public String targetDBParameterGroupIdentifier() {
        return this.targetDBParameterGroupIdentifier;
    }

    public String targetDBParameterGroupDescription() {
        return this.targetDBParameterGroupDescription;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDBParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBParameterGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDBParameterGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyDbParameterGroupRequest)) {
            return false;
        }
        CopyDbParameterGroupRequest other = (CopyDbParameterGroupRequest)((Object)obj);
        return Objects.equals(this.sourceDBParameterGroupIdentifier(), other.sourceDBParameterGroupIdentifier()) && Objects.equals(this.targetDBParameterGroupIdentifier(), other.targetDBParameterGroupIdentifier()) && Objects.equals(this.targetDBParameterGroupDescription(), other.targetDBParameterGroupDescription()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CopyDbParameterGroupRequest").add("SourceDBParameterGroupIdentifier", (Object)this.sourceDBParameterGroupIdentifier()).add("TargetDBParameterGroupIdentifier", (Object)this.targetDBParameterGroupIdentifier()).add("TargetDBParameterGroupDescription", (Object)this.targetDBParameterGroupDescription()).add("Tags", this.tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceDBParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.sourceDBParameterGroupIdentifier()));
            }
            case "TargetDBParameterGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.targetDBParameterGroupIdentifier()));
            }
            case "TargetDBParameterGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.targetDBParameterGroupDescription()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String sourceDBParameterGroupIdentifier;
        private String targetDBParameterGroupIdentifier;
        private String targetDBParameterGroupDescription;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CopyDbParameterGroupRequest model) {
            super(model);
            this.sourceDBParameterGroupIdentifier(model.sourceDBParameterGroupIdentifier);
            this.targetDBParameterGroupIdentifier(model.targetDBParameterGroupIdentifier);
            this.targetDBParameterGroupDescription(model.targetDBParameterGroupDescription);
            this.tags(model.tags);
        }

        public final String getSourceDBParameterGroupIdentifier() {
            return this.sourceDBParameterGroupIdentifier;
        }

        @Override
        public final Builder sourceDBParameterGroupIdentifier(String sourceDBParameterGroupIdentifier) {
            this.sourceDBParameterGroupIdentifier = sourceDBParameterGroupIdentifier;
            return this;
        }

        public final void setSourceDBParameterGroupIdentifier(String sourceDBParameterGroupIdentifier) {
            this.sourceDBParameterGroupIdentifier = sourceDBParameterGroupIdentifier;
        }

        public final String getTargetDBParameterGroupIdentifier() {
            return this.targetDBParameterGroupIdentifier;
        }

        @Override
        public final Builder targetDBParameterGroupIdentifier(String targetDBParameterGroupIdentifier) {
            this.targetDBParameterGroupIdentifier = targetDBParameterGroupIdentifier;
            return this;
        }

        public final void setTargetDBParameterGroupIdentifier(String targetDBParameterGroupIdentifier) {
            this.targetDBParameterGroupIdentifier = targetDBParameterGroupIdentifier;
        }

        public final String getTargetDBParameterGroupDescription() {
            return this.targetDBParameterGroupDescription;
        }

        @Override
        public final Builder targetDBParameterGroupDescription(String targetDBParameterGroupDescription) {
            this.targetDBParameterGroupDescription = targetDBParameterGroupDescription;
            return this;
        }

        public final void setTargetDBParameterGroupDescription(String targetDBParameterGroupDescription) {
            this.targetDBParameterGroupDescription = targetDBParameterGroupDescription;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyDbParameterGroupRequest build() {
            return new CopyDbParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    CopyableBuilder<Builder, CopyDbParameterGroupRequest> {
        public Builder sourceDBParameterGroupIdentifier(String var1);

        public Builder targetDBParameterGroupIdentifier(String var1);

        public Builder targetDBParameterGroupDescription(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

