/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBClusterBacktrack;
import software.amazon.awssdk.services.rds.model.DBClusterBacktrackListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbClusterBacktracksResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbClusterBacktracksResponse> {
    private final String marker;
    private final List<DBClusterBacktrack> dbClusterBacktracks;

    private DescribeDbClusterBacktracksResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbClusterBacktracks = builder.dbClusterBacktracks;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBClusterBacktrack> dbClusterBacktracks() {
        return this.dbClusterBacktracks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterBacktracks());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbClusterBacktracksResponse)) {
            return false;
        }
        DescribeDbClusterBacktracksResponse other = (DescribeDbClusterBacktracksResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbClusterBacktracks(), other.dbClusterBacktracks());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbClusterBacktracksResponse").add("Marker", (Object)this.marker()).add("DBClusterBacktracks", this.dbClusterBacktracks()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBClusterBacktracks": {
                return Optional.ofNullable(clazz.cast(this.dbClusterBacktracks()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBClusterBacktrack> dbClusterBacktracks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbClusterBacktracksResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbClusterBacktracks(model.dbClusterBacktracks);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBClusterBacktrack.Builder> getDBClusterBacktracks() {
            return this.dbClusterBacktracks != null ? (Collection)this.dbClusterBacktracks.stream().map(DBClusterBacktrack::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbClusterBacktracks(Collection<DBClusterBacktrack> dbClusterBacktracks) {
            this.dbClusterBacktracks = DBClusterBacktrackListCopier.copy(dbClusterBacktracks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterBacktracks(DBClusterBacktrack ... dbClusterBacktracks) {
            this.dbClusterBacktracks(Arrays.asList(dbClusterBacktracks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterBacktracks(Consumer<DBClusterBacktrack.Builder> ... dbClusterBacktracks) {
            this.dbClusterBacktracks(Stream.of(dbClusterBacktracks).map(c -> (DBClusterBacktrack)((DBClusterBacktrack.Builder)DBClusterBacktrack.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDBClusterBacktracks(Collection<DBClusterBacktrack.BuilderImpl> dbClusterBacktracks) {
            this.dbClusterBacktracks = DBClusterBacktrackListCopier.copyFromBuilder(dbClusterBacktracks);
        }

        @Override
        public DescribeDbClusterBacktracksResponse build() {
            return new DescribeDbClusterBacktracksResponse(this);
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    CopyableBuilder<Builder, DescribeDbClusterBacktracksResponse> {
        public Builder marker(String var1);

        public Builder dbClusterBacktracks(Collection<DBClusterBacktrack> var1);

        public Builder dbClusterBacktracks(DBClusterBacktrack ... var1);

        public Builder dbClusterBacktracks(Consumer<DBClusterBacktrack.Builder> ... var1);
    }
}

