/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupNameListCopier;
import software.amazon.awssdk.services.rds.model.OptionSetting;
import software.amazon.awssdk.services.rds.model.OptionSettingsListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptionConfiguration
implements ToCopyableBuilder<Builder, OptionConfiguration> {
    private final String optionName;
    private final Integer port;
    private final String optionVersion;
    private final List<String> dbSecurityGroupMemberships;
    private final List<String> vpcSecurityGroupMemberships;
    private final List<OptionSetting> optionSettings;

    private OptionConfiguration(BuilderImpl builder) {
        this.optionName = builder.optionName;
        this.port = builder.port;
        this.optionVersion = builder.optionVersion;
        this.dbSecurityGroupMemberships = builder.dbSecurityGroupMemberships;
        this.vpcSecurityGroupMemberships = builder.vpcSecurityGroupMemberships;
        this.optionSettings = builder.optionSettings;
    }

    public String optionName() {
        return this.optionName;
    }

    public Integer port() {
        return this.port;
    }

    public String optionVersion() {
        return this.optionVersion;
    }

    public List<String> dbSecurityGroupMemberships() {
        return this.dbSecurityGroupMemberships;
    }

    public List<String> vpcSecurityGroupMemberships() {
        return this.vpcSecurityGroupMemberships;
    }

    public List<OptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSecurityGroupMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionConfiguration)) {
            return false;
        }
        OptionConfiguration other = (OptionConfiguration)obj;
        return Objects.equals(this.optionName(), other.optionName()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.optionVersion(), other.optionVersion()) && Objects.equals(this.dbSecurityGroupMemberships(), other.dbSecurityGroupMemberships()) && Objects.equals(this.vpcSecurityGroupMemberships(), other.vpcSecurityGroupMemberships()) && Objects.equals(this.optionSettings(), other.optionSettings());
    }

    public String toString() {
        return ToString.builder((String)"OptionConfiguration").add("OptionName", (Object)this.optionName()).add("Port", (Object)this.port()).add("OptionVersion", (Object)this.optionVersion()).add("DBSecurityGroupMemberships", this.dbSecurityGroupMemberships()).add("VpcSecurityGroupMemberships", this.vpcSecurityGroupMemberships()).add("OptionSettings", this.optionSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionName": {
                return Optional.ofNullable(clazz.cast(this.optionName()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "OptionVersion": {
                return Optional.ofNullable(clazz.cast(this.optionVersion()));
            }
            case "DBSecurityGroupMemberships": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroupMemberships()));
            }
            case "VpcSecurityGroupMemberships": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupMemberships()));
            }
            case "OptionSettings": {
                return Optional.ofNullable(clazz.cast(this.optionSettings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String optionName;
        private Integer port;
        private String optionVersion;
        private List<String> dbSecurityGroupMemberships = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupMemberships = DefaultSdkAutoConstructList.getInstance();
        private List<OptionSetting> optionSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OptionConfiguration model) {
            this.optionName(model.optionName);
            this.port(model.port);
            this.optionVersion(model.optionVersion);
            this.dbSecurityGroupMemberships(model.dbSecurityGroupMemberships);
            this.vpcSecurityGroupMemberships(model.vpcSecurityGroupMemberships);
            this.optionSettings(model.optionSettings);
        }

        public final String getOptionName() {
            return this.optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getOptionVersion() {
            return this.optionVersion;
        }

        @Override
        public final Builder optionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
            return this;
        }

        public final void setOptionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
        }

        public final Collection<String> getDBSecurityGroupMemberships() {
            return this.dbSecurityGroupMemberships;
        }

        @Override
        public final Builder dbSecurityGroupMemberships(Collection<String> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupNameListCopier.copy(dbSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroupMemberships(String ... dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships(Arrays.asList(dbSecurityGroupMemberships));
            return this;
        }

        public final void setDBSecurityGroupMemberships(Collection<String> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupNameListCopier.copy(dbSecurityGroupMemberships);
        }

        public final Collection<String> getVpcSecurityGroupMemberships() {
            return this.vpcSecurityGroupMemberships;
        }

        @Override
        public final Builder vpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupMemberships(String ... vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships(Arrays.asList(vpcSecurityGroupMemberships));
            return this;
        }

        public final void setVpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupMemberships);
        }

        public final Collection<OptionSetting.Builder> getOptionSettings() {
            return this.optionSettings != null ? (Collection)this.optionSettings.stream().map(OptionSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder optionSettings(Collection<OptionSetting> optionSettings) {
            this.optionSettings = OptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(OptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(Consumer<OptionSetting.Builder> ... optionSettings) {
            this.optionSettings(Stream.of(optionSettings).map(c -> (OptionSetting)((OptionSetting.Builder)OptionSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOptionSettings(Collection<OptionSetting.BuilderImpl> optionSettings) {
            this.optionSettings = OptionSettingsListCopier.copyFromBuilder(optionSettings);
        }

        public OptionConfiguration build() {
            return new OptionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionConfiguration> {
        public Builder optionName(String var1);

        public Builder port(Integer var1);

        public Builder optionVersion(String var1);

        public Builder dbSecurityGroupMemberships(Collection<String> var1);

        public Builder dbSecurityGroupMemberships(String ... var1);

        public Builder vpcSecurityGroupMemberships(Collection<String> var1);

        public Builder vpcSecurityGroupMemberships(String ... var1);

        public Builder optionSettings(Collection<OptionSetting> var1);

        public Builder optionSettings(OptionSetting ... var1);

        public Builder optionSettings(Consumer<OptionSetting.Builder> ... var1);
    }
}

