/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AvailableProcessorFeature;
import software.amazon.awssdk.services.rds.model.AvailableProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.ValidStorageOptions;
import software.amazon.awssdk.services.rds.model.ValidStorageOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidDBInstanceModificationsMessage
implements ToCopyableBuilder<Builder, ValidDBInstanceModificationsMessage> {
    private final List<ValidStorageOptions> storage;
    private final List<AvailableProcessorFeature> validProcessorFeatures;

    private ValidDBInstanceModificationsMessage(BuilderImpl builder) {
        this.storage = builder.storage;
        this.validProcessorFeatures = builder.validProcessorFeatures;
    }

    public List<ValidStorageOptions> storage() {
        return this.storage;
    }

    public List<AvailableProcessorFeature> validProcessorFeatures() {
        return this.validProcessorFeatures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        hashCode = 31 * hashCode + Objects.hashCode(this.validProcessorFeatures());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidDBInstanceModificationsMessage)) {
            return false;
        }
        ValidDBInstanceModificationsMessage other = (ValidDBInstanceModificationsMessage)obj;
        return Objects.equals(this.storage(), other.storage()) && Objects.equals(this.validProcessorFeatures(), other.validProcessorFeatures());
    }

    public String toString() {
        return ToString.builder((String)"ValidDBInstanceModificationsMessage").add("Storage", this.storage()).add("ValidProcessorFeatures", this.validProcessorFeatures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
            case "ValidProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.validProcessorFeatures()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ValidStorageOptions> storage = DefaultSdkAutoConstructList.getInstance();
        private List<AvailableProcessorFeature> validProcessorFeatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidDBInstanceModificationsMessage model) {
            this.storage(model.storage);
            this.validProcessorFeatures(model.validProcessorFeatures);
        }

        public final Collection<ValidStorageOptions.Builder> getStorage() {
            return this.storage != null ? (Collection)this.storage.stream().map(ValidStorageOptions::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storage(Collection<ValidStorageOptions> storage) {
            this.storage = ValidStorageOptionsListCopier.copy(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(ValidStorageOptions ... storage) {
            this.storage(Arrays.asList(storage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(Consumer<ValidStorageOptions.Builder> ... storage) {
            this.storage(Stream.of(storage).map(c -> (ValidStorageOptions)((ValidStorageOptions.Builder)ValidStorageOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorage(Collection<ValidStorageOptions.BuilderImpl> storage) {
            this.storage = ValidStorageOptionsListCopier.copyFromBuilder(storage);
        }

        public final Collection<AvailableProcessorFeature.Builder> getValidProcessorFeatures() {
            return this.validProcessorFeatures != null ? (Collection)this.validProcessorFeatures.stream().map(AvailableProcessorFeature::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validProcessorFeatures(Collection<AvailableProcessorFeature> validProcessorFeatures) {
            this.validProcessorFeatures = AvailableProcessorFeatureListCopier.copy(validProcessorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validProcessorFeatures(AvailableProcessorFeature ... validProcessorFeatures) {
            this.validProcessorFeatures(Arrays.asList(validProcessorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validProcessorFeatures(Consumer<AvailableProcessorFeature.Builder> ... validProcessorFeatures) {
            this.validProcessorFeatures(Stream.of(validProcessorFeatures).map(c -> (AvailableProcessorFeature)((AvailableProcessorFeature.Builder)AvailableProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setValidProcessorFeatures(Collection<AvailableProcessorFeature.BuilderImpl> validProcessorFeatures) {
            this.validProcessorFeatures = AvailableProcessorFeatureListCopier.copyFromBuilder(validProcessorFeatures);
        }

        public ValidDBInstanceModificationsMessage build() {
            return new ValidDBInstanceModificationsMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidDBInstanceModificationsMessage> {
        public Builder storage(Collection<ValidStorageOptions> var1);

        public Builder storage(ValidStorageOptions ... var1);

        public Builder storage(Consumer<ValidStorageOptions.Builder> ... var1);

        public Builder validProcessorFeatures(Collection<AvailableProcessorFeature> var1);

        public Builder validProcessorFeatures(AvailableProcessorFeature ... var1);

        public Builder validProcessorFeatures(Consumer<AvailableProcessorFeature.Builder> ... var1);
    }
}

