/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.AddRoleToDbClusterRequest;

public class AddRoleToDbClusterRequestMarshaller
implements Marshaller<Request<AddRoleToDbClusterRequest>, AddRoleToDbClusterRequest> {
    public Request<AddRoleToDbClusterRequest> marshall(AddRoleToDbClusterRequest addRoleToDbClusterRequest) {
        if (addRoleToDbClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)addRoleToDbClusterRequest, "RdsClient");
        request.addParameter("Action", "AddRoleToDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (addRoleToDbClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)addRoleToDbClusterRequest.dbClusterIdentifier()));
        }
        if (addRoleToDbClusterRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringConversion.fromString((String)addRoleToDbClusterRequest.roleArn()));
        }
        return request;
    }
}

