/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.CloudwatchLogsExportConfiguration;

public class CloudwatchLogsExportConfigurationUnmarshaller
implements Unmarshaller<CloudwatchLogsExportConfiguration, StaxUnmarshallerContext> {
    private static final CloudwatchLogsExportConfigurationUnmarshaller INSTANCE = new CloudwatchLogsExportConfigurationUnmarshaller();

    public CloudwatchLogsExportConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudwatchLogsExportConfiguration.Builder cloudwatchLogsExportConfiguration;
        block7: {
            cloudwatchLogsExportConfiguration = CloudwatchLogsExportConfiguration.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> enableLogTypes = null;
            ArrayList<String> disableLogTypes = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    cloudwatchLogsExportConfiguration.enableLogTypes(enableLogTypes);
                    cloudwatchLogsExportConfiguration.disableLogTypes(disableLogTypes);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("EnableLogTypes", targetDepth)) {
                        enableLogTypes = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("EnableLogTypes/member", targetDepth)) {
                        enableLogTypes.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DisableLogTypes", targetDepth)) {
                        disableLogTypes = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("DisableLogTypes/member", targetDepth)) continue;
                    disableLogTypes.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            cloudwatchLogsExportConfiguration.enableLogTypes(enableLogTypes);
            cloudwatchLogsExportConfiguration.disableLogTypes(disableLogTypes);
        }
        return (CloudwatchLogsExportConfiguration)cloudwatchLogsExportConfiguration.build();
    }

    public static CloudwatchLogsExportConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

