/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.CreateDbClusterRequest;
import software.amazon.awssdk.services.rds.model.ScalingConfiguration;
import software.amazon.awssdk.services.rds.model.Tag;

public class CreateDbClusterRequestMarshaller
implements Marshaller<Request<CreateDbClusterRequest>, CreateDbClusterRequest> {
    public Request<CreateDbClusterRequest> marshall(CreateDbClusterRequest createDbClusterRequest) {
        ScalingConfiguration scalingConfiguration;
        if (createDbClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createDbClusterRequest, "RdsClient");
        request.addParameter("Action", "CreateDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDbClusterRequest.availabilityZones().isEmpty() && !(createDbClusterRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            request.addParameter("AvailabilityZones", "");
        } else if (!createDbClusterRequest.availabilityZones().isEmpty() && !(createDbClusterRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            List<String> availabilityZonesList = createDbClusterRequest.availabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringConversion.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (createDbClusterRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringConversion.fromInteger((Integer)createDbClusterRequest.backupRetentionPeriod()));
        }
        if (createDbClusterRequest.characterSetName() != null) {
            request.addParameter("CharacterSetName", StringConversion.fromString((String)createDbClusterRequest.characterSetName()));
        }
        if (createDbClusterRequest.databaseName() != null) {
            request.addParameter("DatabaseName", StringConversion.fromString((String)createDbClusterRequest.databaseName()));
        }
        if (createDbClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)createDbClusterRequest.dbClusterIdentifier()));
        }
        if (createDbClusterRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringConversion.fromString((String)createDbClusterRequest.dbClusterParameterGroupName()));
        }
        if (createDbClusterRequest.vpcSecurityGroupIds().isEmpty() && !(createDbClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!createDbClusterRequest.vpcSecurityGroupIds().isEmpty() && !(createDbClusterRequest.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = createDbClusterRequest.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDbClusterRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)createDbClusterRequest.dbSubnetGroupName()));
        }
        if (createDbClusterRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)createDbClusterRequest.engine()));
        }
        if (createDbClusterRequest.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)createDbClusterRequest.engineVersion()));
        }
        if (createDbClusterRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)createDbClusterRequest.port()));
        }
        if (createDbClusterRequest.masterUsername() != null) {
            request.addParameter("MasterUsername", StringConversion.fromString((String)createDbClusterRequest.masterUsername()));
        }
        if (createDbClusterRequest.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringConversion.fromString((String)createDbClusterRequest.masterUserPassword()));
        }
        if (createDbClusterRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)createDbClusterRequest.optionGroupName()));
        }
        if (createDbClusterRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringConversion.fromString((String)createDbClusterRequest.preferredBackupWindow()));
        }
        if (createDbClusterRequest.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)createDbClusterRequest.preferredMaintenanceWindow()));
        }
        if (createDbClusterRequest.replicationSourceIdentifier() != null) {
            request.addParameter("ReplicationSourceIdentifier", StringConversion.fromString((String)createDbClusterRequest.replicationSourceIdentifier()));
        }
        if (createDbClusterRequest.tags().isEmpty() && !(createDbClusterRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createDbClusterRequest.tags().isEmpty() && !(createDbClusterRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createDbClusterRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createDbClusterRequest.storageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringConversion.fromBoolean((Boolean)createDbClusterRequest.storageEncrypted()));
        }
        if (createDbClusterRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)createDbClusterRequest.kmsKeyId()));
        }
        if (createDbClusterRequest.preSignedUrl() != null) {
            request.addParameter("PreSignedUrl", StringConversion.fromString((String)createDbClusterRequest.preSignedUrl()));
        }
        if (createDbClusterRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)createDbClusterRequest.enableIAMDatabaseAuthentication()));
        }
        if (createDbClusterRequest.backtrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringConversion.fromLong((Long)createDbClusterRequest.backtrackWindow()));
        }
        if (createDbClusterRequest.enableCloudwatchLogsExports().isEmpty() && !(createDbClusterRequest.enableCloudwatchLogsExports() instanceof SdkAutoConstructList)) {
            request.addParameter("EnableCloudwatchLogsExports", "");
        } else if (!createDbClusterRequest.enableCloudwatchLogsExports().isEmpty() && !(createDbClusterRequest.enableCloudwatchLogsExports() instanceof SdkAutoConstructList)) {
            List<String> enableCloudwatchLogsExportsList = createDbClusterRequest.enableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringConversion.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (createDbClusterRequest.engineMode() != null) {
            request.addParameter("EngineMode", StringConversion.fromString((String)createDbClusterRequest.engineMode()));
        }
        if ((scalingConfiguration = createDbClusterRequest.scalingConfiguration()) != null) {
            if (scalingConfiguration.minCapacity() != null) {
                request.addParameter("ScalingConfiguration.MinCapacity", StringConversion.fromInteger((Integer)scalingConfiguration.minCapacity()));
            }
            if (scalingConfiguration.maxCapacity() != null) {
                request.addParameter("ScalingConfiguration.MaxCapacity", StringConversion.fromInteger((Integer)scalingConfiguration.maxCapacity()));
            }
            if (scalingConfiguration.autoPause() != null) {
                request.addParameter("ScalingConfiguration.AutoPause", StringConversion.fromBoolean((Boolean)scalingConfiguration.autoPause()));
            }
            if (scalingConfiguration.secondsUntilAutoPause() != null) {
                request.addParameter("ScalingConfiguration.SecondsUntilAutoPause", StringConversion.fromInteger((Integer)scalingConfiguration.secondsUntilAutoPause()));
            }
        }
        return request;
    }
}

