/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.DescribeDbParametersRequest;
import software.amazon.awssdk.services.rds.model.Filter;

public class DescribeDbParametersRequestMarshaller
implements Marshaller<Request<DescribeDbParametersRequest>, DescribeDbParametersRequest> {
    public Request<DescribeDbParametersRequest> marshall(DescribeDbParametersRequest describeDbParametersRequest) {
        if (describeDbParametersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDbParametersRequest, "RdsClient");
        request.addParameter("Action", "DescribeDBParameters");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDbParametersRequest.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringConversion.fromString((String)describeDbParametersRequest.dbParameterGroupName()));
        }
        if (describeDbParametersRequest.source() != null) {
            request.addParameter("Source", StringConversion.fromString((String)describeDbParametersRequest.source()));
        }
        if (describeDbParametersRequest.filters().isEmpty() && !(describeDbParametersRequest.filters() instanceof SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeDbParametersRequest.filters().isEmpty() && !(describeDbParametersRequest.filters() instanceof SdkAutoConstructList)) {
            List<Filter> filtersList = describeDbParametersRequest.filters();
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Name", StringConversion.fromString((String)filtersListValue.name()));
                }
                if (filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    request.addParameter("Filters.Filter." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty() && !(filtersListValue.values() instanceof SdkAutoConstructList)) {
                    List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.Filter." + filtersListIndex + ".Values.Value." + valuesListIndex, StringConversion.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeDbParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeDbParametersRequest.maxRecords()));
        }
        if (describeDbParametersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeDbParametersRequest.marker()));
        }
        return request;
    }
}

