/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.ModifyCurrentDbClusterCapacityRequest;

public class ModifyCurrentDbClusterCapacityRequestMarshaller
implements Marshaller<Request<ModifyCurrentDbClusterCapacityRequest>, ModifyCurrentDbClusterCapacityRequest> {
    public Request<ModifyCurrentDbClusterCapacityRequest> marshall(ModifyCurrentDbClusterCapacityRequest modifyCurrentDbClusterCapacityRequest) {
        if (modifyCurrentDbClusterCapacityRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)modifyCurrentDbClusterCapacityRequest, "RdsClient");
        request.addParameter("Action", "ModifyCurrentDBClusterCapacity");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyCurrentDbClusterCapacityRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)modifyCurrentDbClusterCapacityRequest.dbClusterIdentifier()));
        }
        if (modifyCurrentDbClusterCapacityRequest.capacity() != null) {
            request.addParameter("Capacity", StringConversion.fromInteger((Integer)modifyCurrentDbClusterCapacityRequest.capacity()));
        }
        if (modifyCurrentDbClusterCapacityRequest.secondsBeforeTimeout() != null) {
            request.addParameter("SecondsBeforeTimeout", StringConversion.fromInteger((Integer)modifyCurrentDbClusterCapacityRequest.secondsBeforeTimeout()));
        }
        if (modifyCurrentDbClusterCapacityRequest.timeoutAction() != null) {
            request.addParameter("TimeoutAction", StringConversion.fromString((String)modifyCurrentDbClusterCapacityRequest.timeoutAction()));
        }
        return request;
    }
}

