/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.PromoteReadReplicaRequest;

public class PromoteReadReplicaRequestMarshaller
implements Marshaller<Request<PromoteReadReplicaRequest>, PromoteReadReplicaRequest> {
    public Request<PromoteReadReplicaRequest> marshall(PromoteReadReplicaRequest promoteReadReplicaRequest) {
        if (promoteReadReplicaRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)promoteReadReplicaRequest, "RdsClient");
        request.addParameter("Action", "PromoteReadReplica");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (promoteReadReplicaRequest.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)promoteReadReplicaRequest.dbInstanceIdentifier()));
        }
        if (promoteReadReplicaRequest.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringConversion.fromInteger((Integer)promoteReadReplicaRequest.backupRetentionPeriod()));
        }
        if (promoteReadReplicaRequest.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringConversion.fromString((String)promoteReadReplicaRequest.preferredBackupWindow()));
        }
        return request;
    }
}

