/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.RemoveRoleFromDbClusterRequest;

public class RemoveRoleFromDbClusterRequestMarshaller
implements Marshaller<Request<RemoveRoleFromDbClusterRequest>, RemoveRoleFromDbClusterRequest> {
    public Request<RemoveRoleFromDbClusterRequest> marshall(RemoveRoleFromDbClusterRequest removeRoleFromDbClusterRequest) {
        if (removeRoleFromDbClusterRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)removeRoleFromDbClusterRequest, "RdsClient");
        request.addParameter("Action", "RemoveRoleFromDBCluster");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (removeRoleFromDbClusterRequest.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)removeRoleFromDbClusterRequest.dbClusterIdentifier()));
        }
        if (removeRoleFromDbClusterRequest.roleArn() != null) {
            request.addParameter("RoleArn", StringConversion.fromString((String)removeRoleFromDbClusterRequest.roleArn()));
        }
        return request;
    }
}

