/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.Parameter;
import software.amazon.awssdk.services.rds.model.ResetDbClusterParameterGroupRequest;

public class ResetDbClusterParameterGroupRequestMarshaller
implements Marshaller<Request<ResetDbClusterParameterGroupRequest>, ResetDbClusterParameterGroupRequest> {
    public Request<ResetDbClusterParameterGroupRequest> marshall(ResetDbClusterParameterGroupRequest resetDbClusterParameterGroupRequest) {
        if (resetDbClusterParameterGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)resetDbClusterParameterGroupRequest, "RdsClient");
        request.addParameter("Action", "ResetDBClusterParameterGroup");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetDbClusterParameterGroupRequest.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringConversion.fromString((String)resetDbClusterParameterGroupRequest.dbClusterParameterGroupName()));
        }
        if (resetDbClusterParameterGroupRequest.resetAllParameters() != null) {
            request.addParameter("ResetAllParameters", StringConversion.fromBoolean((Boolean)resetDbClusterParameterGroupRequest.resetAllParameters()));
        }
        if (resetDbClusterParameterGroupRequest.parameters().isEmpty() && !(resetDbClusterParameterGroupRequest.parameters() instanceof SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!resetDbClusterParameterGroupRequest.parameters().isEmpty() && !(resetDbClusterParameterGroupRequest.parameters() instanceof SdkAutoConstructList)) {
            List<Parameter> parametersList = resetDbClusterParameterGroupRequest.parameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.parameterName() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterName", StringConversion.fromString((String)parametersListValue.parameterName()));
                }
                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterValue", StringConversion.fromString((String)parametersListValue.parameterValue()));
                }
                if (parametersListValue.description() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".Description", StringConversion.fromString((String)parametersListValue.description()));
                }
                if (parametersListValue.source() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".Source", StringConversion.fromString((String)parametersListValue.source()));
                }
                if (parametersListValue.applyType() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyType", StringConversion.fromString((String)parametersListValue.applyType()));
                }
                if (parametersListValue.dataType() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".DataType", StringConversion.fromString((String)parametersListValue.dataType()));
                }
                if (parametersListValue.allowedValues() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".AllowedValues", StringConversion.fromString((String)parametersListValue.allowedValues()));
                }
                if (parametersListValue.isModifiable() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".IsModifiable", StringConversion.fromBoolean((Boolean)parametersListValue.isModifiable()));
                }
                if (parametersListValue.minimumEngineVersion() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".MinimumEngineVersion", StringConversion.fromString((String)parametersListValue.minimumEngineVersion()));
                }
                if (parametersListValue.applyMethodAsString() != null) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyMethod", StringConversion.fromString((String)parametersListValue.applyMethodAsString()));
                }
                if (parametersListValue.supportedEngineModes().isEmpty() && !(parametersListValue.supportedEngineModes() instanceof SdkAutoConstructList)) {
                    request.addParameter("Parameters.Parameter." + parametersListIndex + ".SupportedEngineModes", "");
                } else if (!parametersListValue.supportedEngineModes().isEmpty() && !(parametersListValue.supportedEngineModes() instanceof SdkAutoConstructList)) {
                    List<String> supportedEngineModesList = parametersListValue.supportedEngineModes();
                    int supportedEngineModesListIndex = 1;
                    for (String supportedEngineModesListValue : supportedEngineModesList) {
                        if (supportedEngineModesListValue != null) {
                            request.addParameter("Parameters.Parameter." + parametersListIndex + ".SupportedEngineModes.member." + supportedEngineModesListIndex, StringConversion.fromString((String)supportedEngineModesListValue));
                        }
                        ++supportedEngineModesListIndex;
                    }
                }
                ++parametersListIndex;
            }
        }
        return request;
    }
}

