/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.RestoreDbClusterFromS3Request;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDbClusterFromS3RequestMarshaller
implements Marshaller<Request<RestoreDbClusterFromS3Request>, RestoreDbClusterFromS3Request> {
    public Request<RestoreDbClusterFromS3Request> marshall(RestoreDbClusterFromS3Request restoreDbClusterFromS3Request) {
        if (restoreDbClusterFromS3Request == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)restoreDbClusterFromS3Request, "RdsClient");
        request.addParameter("Action", "RestoreDBClusterFromS3");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDbClusterFromS3Request.availabilityZones().isEmpty() && !(restoreDbClusterFromS3Request.availabilityZones() instanceof SdkAutoConstructList)) {
            request.addParameter("AvailabilityZones", "");
        } else if (!restoreDbClusterFromS3Request.availabilityZones().isEmpty() && !(restoreDbClusterFromS3Request.availabilityZones() instanceof SdkAutoConstructList)) {
            List<String> availabilityZonesList = restoreDbClusterFromS3Request.availabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringConversion.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (restoreDbClusterFromS3Request.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringConversion.fromInteger((Integer)restoreDbClusterFromS3Request.backupRetentionPeriod()));
        }
        if (restoreDbClusterFromS3Request.characterSetName() != null) {
            request.addParameter("CharacterSetName", StringConversion.fromString((String)restoreDbClusterFromS3Request.characterSetName()));
        }
        if (restoreDbClusterFromS3Request.databaseName() != null) {
            request.addParameter("DatabaseName", StringConversion.fromString((String)restoreDbClusterFromS3Request.databaseName()));
        }
        if (restoreDbClusterFromS3Request.dbClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringConversion.fromString((String)restoreDbClusterFromS3Request.dbClusterIdentifier()));
        }
        if (restoreDbClusterFromS3Request.dbClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringConversion.fromString((String)restoreDbClusterFromS3Request.dbClusterParameterGroupName()));
        }
        if (restoreDbClusterFromS3Request.vpcSecurityGroupIds().isEmpty() && !(restoreDbClusterFromS3Request.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!restoreDbClusterFromS3Request.vpcSecurityGroupIds().isEmpty() && !(restoreDbClusterFromS3Request.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = restoreDbClusterFromS3Request.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (restoreDbClusterFromS3Request.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)restoreDbClusterFromS3Request.dbSubnetGroupName()));
        }
        if (restoreDbClusterFromS3Request.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)restoreDbClusterFromS3Request.engine()));
        }
        if (restoreDbClusterFromS3Request.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)restoreDbClusterFromS3Request.engineVersion()));
        }
        if (restoreDbClusterFromS3Request.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)restoreDbClusterFromS3Request.port()));
        }
        if (restoreDbClusterFromS3Request.masterUsername() != null) {
            request.addParameter("MasterUsername", StringConversion.fromString((String)restoreDbClusterFromS3Request.masterUsername()));
        }
        if (restoreDbClusterFromS3Request.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringConversion.fromString((String)restoreDbClusterFromS3Request.masterUserPassword()));
        }
        if (restoreDbClusterFromS3Request.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)restoreDbClusterFromS3Request.optionGroupName()));
        }
        if (restoreDbClusterFromS3Request.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringConversion.fromString((String)restoreDbClusterFromS3Request.preferredBackupWindow()));
        }
        if (restoreDbClusterFromS3Request.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)restoreDbClusterFromS3Request.preferredMaintenanceWindow()));
        }
        if (restoreDbClusterFromS3Request.tags().isEmpty() && !(restoreDbClusterFromS3Request.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!restoreDbClusterFromS3Request.tags().isEmpty() && !(restoreDbClusterFromS3Request.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = restoreDbClusterFromS3Request.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDbClusterFromS3Request.storageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringConversion.fromBoolean((Boolean)restoreDbClusterFromS3Request.storageEncrypted()));
        }
        if (restoreDbClusterFromS3Request.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)restoreDbClusterFromS3Request.kmsKeyId()));
        }
        if (restoreDbClusterFromS3Request.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)restoreDbClusterFromS3Request.enableIAMDatabaseAuthentication()));
        }
        if (restoreDbClusterFromS3Request.sourceEngine() != null) {
            request.addParameter("SourceEngine", StringConversion.fromString((String)restoreDbClusterFromS3Request.sourceEngine()));
        }
        if (restoreDbClusterFromS3Request.sourceEngineVersion() != null) {
            request.addParameter("SourceEngineVersion", StringConversion.fromString((String)restoreDbClusterFromS3Request.sourceEngineVersion()));
        }
        if (restoreDbClusterFromS3Request.s3BucketName() != null) {
            request.addParameter("S3BucketName", StringConversion.fromString((String)restoreDbClusterFromS3Request.s3BucketName()));
        }
        if (restoreDbClusterFromS3Request.s3Prefix() != null) {
            request.addParameter("S3Prefix", StringConversion.fromString((String)restoreDbClusterFromS3Request.s3Prefix()));
        }
        if (restoreDbClusterFromS3Request.s3IngestionRoleArn() != null) {
            request.addParameter("S3IngestionRoleArn", StringConversion.fromString((String)restoreDbClusterFromS3Request.s3IngestionRoleArn()));
        }
        if (restoreDbClusterFromS3Request.backtrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringConversion.fromLong((Long)restoreDbClusterFromS3Request.backtrackWindow()));
        }
        if (restoreDbClusterFromS3Request.enableCloudwatchLogsExports().isEmpty() && !(restoreDbClusterFromS3Request.enableCloudwatchLogsExports() instanceof SdkAutoConstructList)) {
            request.addParameter("EnableCloudwatchLogsExports", "");
        } else if (!restoreDbClusterFromS3Request.enableCloudwatchLogsExports().isEmpty() && !(restoreDbClusterFromS3Request.enableCloudwatchLogsExports() instanceof SdkAutoConstructList)) {
            List<String> enableCloudwatchLogsExportsList = restoreDbClusterFromS3Request.enableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringConversion.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        return request;
    }
}

