/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.ProcessorFeature;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceFromS3Request;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDbInstanceFromS3RequestMarshaller
implements Marshaller<Request<RestoreDbInstanceFromS3Request>, RestoreDbInstanceFromS3Request> {
    public Request<RestoreDbInstanceFromS3Request> marshall(RestoreDbInstanceFromS3Request restoreDbInstanceFromS3Request) {
        if (restoreDbInstanceFromS3Request == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)restoreDbInstanceFromS3Request, "RdsClient");
        request.addParameter("Action", "RestoreDBInstanceFromS3");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDbInstanceFromS3Request.dbName() != null) {
            request.addParameter("DBName", StringConversion.fromString((String)restoreDbInstanceFromS3Request.dbName()));
        }
        if (restoreDbInstanceFromS3Request.dbInstanceIdentifier() != null) {
            request.addParameter("DBInstanceIdentifier", StringConversion.fromString((String)restoreDbInstanceFromS3Request.dbInstanceIdentifier()));
        }
        if (restoreDbInstanceFromS3Request.allocatedStorage() != null) {
            request.addParameter("AllocatedStorage", StringConversion.fromInteger((Integer)restoreDbInstanceFromS3Request.allocatedStorage()));
        }
        if (restoreDbInstanceFromS3Request.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringConversion.fromString((String)restoreDbInstanceFromS3Request.dbInstanceClass()));
        }
        if (restoreDbInstanceFromS3Request.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)restoreDbInstanceFromS3Request.engine()));
        }
        if (restoreDbInstanceFromS3Request.masterUsername() != null) {
            request.addParameter("MasterUsername", StringConversion.fromString((String)restoreDbInstanceFromS3Request.masterUsername()));
        }
        if (restoreDbInstanceFromS3Request.masterUserPassword() != null) {
            request.addParameter("MasterUserPassword", StringConversion.fromString((String)restoreDbInstanceFromS3Request.masterUserPassword()));
        }
        if (restoreDbInstanceFromS3Request.dbSecurityGroups().isEmpty() && !(restoreDbInstanceFromS3Request.dbSecurityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("DBSecurityGroups", "");
        } else if (!restoreDbInstanceFromS3Request.dbSecurityGroups().isEmpty() && !(restoreDbInstanceFromS3Request.dbSecurityGroups() instanceof SdkAutoConstructList)) {
            List<String> dBSecurityGroupsList = restoreDbInstanceFromS3Request.dbSecurityGroups();
            int dBSecurityGroupsListIndex = 1;
            for (String dBSecurityGroupsListValue : dBSecurityGroupsList) {
                if (dBSecurityGroupsListValue != null) {
                    request.addParameter("DBSecurityGroups.DBSecurityGroupName." + dBSecurityGroupsListIndex, StringConversion.fromString((String)dBSecurityGroupsListValue));
                }
                ++dBSecurityGroupsListIndex;
            }
        }
        if (restoreDbInstanceFromS3Request.vpcSecurityGroupIds().isEmpty() && !(restoreDbInstanceFromS3Request.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            request.addParameter("VpcSecurityGroupIds", "");
        } else if (!restoreDbInstanceFromS3Request.vpcSecurityGroupIds().isEmpty() && !(restoreDbInstanceFromS3Request.vpcSecurityGroupIds() instanceof SdkAutoConstructList)) {
            List<String> vpcSecurityGroupIdsList = restoreDbInstanceFromS3Request.vpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringConversion.fromString((String)vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (restoreDbInstanceFromS3Request.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)restoreDbInstanceFromS3Request.availabilityZone()));
        }
        if (restoreDbInstanceFromS3Request.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)restoreDbInstanceFromS3Request.dbSubnetGroupName()));
        }
        if (restoreDbInstanceFromS3Request.preferredMaintenanceWindow() != null) {
            request.addParameter("PreferredMaintenanceWindow", StringConversion.fromString((String)restoreDbInstanceFromS3Request.preferredMaintenanceWindow()));
        }
        if (restoreDbInstanceFromS3Request.dbParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringConversion.fromString((String)restoreDbInstanceFromS3Request.dbParameterGroupName()));
        }
        if (restoreDbInstanceFromS3Request.backupRetentionPeriod() != null) {
            request.addParameter("BackupRetentionPeriod", StringConversion.fromInteger((Integer)restoreDbInstanceFromS3Request.backupRetentionPeriod()));
        }
        if (restoreDbInstanceFromS3Request.preferredBackupWindow() != null) {
            request.addParameter("PreferredBackupWindow", StringConversion.fromString((String)restoreDbInstanceFromS3Request.preferredBackupWindow()));
        }
        if (restoreDbInstanceFromS3Request.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)restoreDbInstanceFromS3Request.port()));
        }
        if (restoreDbInstanceFromS3Request.multiAZ() != null) {
            request.addParameter("MultiAZ", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromS3Request.multiAZ()));
        }
        if (restoreDbInstanceFromS3Request.engineVersion() != null) {
            request.addParameter("EngineVersion", StringConversion.fromString((String)restoreDbInstanceFromS3Request.engineVersion()));
        }
        if (restoreDbInstanceFromS3Request.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromS3Request.autoMinorVersionUpgrade()));
        }
        if (restoreDbInstanceFromS3Request.licenseModel() != null) {
            request.addParameter("LicenseModel", StringConversion.fromString((String)restoreDbInstanceFromS3Request.licenseModel()));
        }
        if (restoreDbInstanceFromS3Request.iops() != null) {
            request.addParameter("Iops", StringConversion.fromInteger((Integer)restoreDbInstanceFromS3Request.iops()));
        }
        if (restoreDbInstanceFromS3Request.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)restoreDbInstanceFromS3Request.optionGroupName()));
        }
        if (restoreDbInstanceFromS3Request.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromS3Request.publiclyAccessible()));
        }
        if (restoreDbInstanceFromS3Request.tags().isEmpty() && !(restoreDbInstanceFromS3Request.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!restoreDbInstanceFromS3Request.tags().isEmpty() && !(restoreDbInstanceFromS3Request.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = restoreDbInstanceFromS3Request.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDbInstanceFromS3Request.storageType() != null) {
            request.addParameter("StorageType", StringConversion.fromString((String)restoreDbInstanceFromS3Request.storageType()));
        }
        if (restoreDbInstanceFromS3Request.storageEncrypted() != null) {
            request.addParameter("StorageEncrypted", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromS3Request.storageEncrypted()));
        }
        if (restoreDbInstanceFromS3Request.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringConversion.fromString((String)restoreDbInstanceFromS3Request.kmsKeyId()));
        }
        if (restoreDbInstanceFromS3Request.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromS3Request.copyTagsToSnapshot()));
        }
        if (restoreDbInstanceFromS3Request.monitoringInterval() != null) {
            request.addParameter("MonitoringInterval", StringConversion.fromInteger((Integer)restoreDbInstanceFromS3Request.monitoringInterval()));
        }
        if (restoreDbInstanceFromS3Request.monitoringRoleArn() != null) {
            request.addParameter("MonitoringRoleArn", StringConversion.fromString((String)restoreDbInstanceFromS3Request.monitoringRoleArn()));
        }
        if (restoreDbInstanceFromS3Request.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromS3Request.enableIAMDatabaseAuthentication()));
        }
        if (restoreDbInstanceFromS3Request.sourceEngine() != null) {
            request.addParameter("SourceEngine", StringConversion.fromString((String)restoreDbInstanceFromS3Request.sourceEngine()));
        }
        if (restoreDbInstanceFromS3Request.sourceEngineVersion() != null) {
            request.addParameter("SourceEngineVersion", StringConversion.fromString((String)restoreDbInstanceFromS3Request.sourceEngineVersion()));
        }
        if (restoreDbInstanceFromS3Request.s3BucketName() != null) {
            request.addParameter("S3BucketName", StringConversion.fromString((String)restoreDbInstanceFromS3Request.s3BucketName()));
        }
        if (restoreDbInstanceFromS3Request.s3Prefix() != null) {
            request.addParameter("S3Prefix", StringConversion.fromString((String)restoreDbInstanceFromS3Request.s3Prefix()));
        }
        if (restoreDbInstanceFromS3Request.s3IngestionRoleArn() != null) {
            request.addParameter("S3IngestionRoleArn", StringConversion.fromString((String)restoreDbInstanceFromS3Request.s3IngestionRoleArn()));
        }
        if (restoreDbInstanceFromS3Request.enablePerformanceInsights() != null) {
            request.addParameter("EnablePerformanceInsights", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromS3Request.enablePerformanceInsights()));
        }
        if (restoreDbInstanceFromS3Request.performanceInsightsKMSKeyId() != null) {
            request.addParameter("PerformanceInsightsKMSKeyId", StringConversion.fromString((String)restoreDbInstanceFromS3Request.performanceInsightsKMSKeyId()));
        }
        if (restoreDbInstanceFromS3Request.performanceInsightsRetentionPeriod() != null) {
            request.addParameter("PerformanceInsightsRetentionPeriod", StringConversion.fromInteger((Integer)restoreDbInstanceFromS3Request.performanceInsightsRetentionPeriod()));
        }
        if (restoreDbInstanceFromS3Request.enableCloudwatchLogsExports().isEmpty() && !(restoreDbInstanceFromS3Request.enableCloudwatchLogsExports() instanceof SdkAutoConstructList)) {
            request.addParameter("EnableCloudwatchLogsExports", "");
        } else if (!restoreDbInstanceFromS3Request.enableCloudwatchLogsExports().isEmpty() && !(restoreDbInstanceFromS3Request.enableCloudwatchLogsExports() instanceof SdkAutoConstructList)) {
            List<String> enableCloudwatchLogsExportsList = restoreDbInstanceFromS3Request.enableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringConversion.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (restoreDbInstanceFromS3Request.processorFeatures().isEmpty() && !(restoreDbInstanceFromS3Request.processorFeatures() instanceof SdkAutoConstructList)) {
            request.addParameter("ProcessorFeatures", "");
        } else if (!restoreDbInstanceFromS3Request.processorFeatures().isEmpty() && !(restoreDbInstanceFromS3Request.processorFeatures() instanceof SdkAutoConstructList)) {
            List<ProcessorFeature> processorFeaturesList = restoreDbInstanceFromS3Request.processorFeatures();
            int processorFeaturesListIndex = 1;
            for (ProcessorFeature processorFeaturesListValue : processorFeaturesList) {
                if (processorFeaturesListValue.name() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Name", StringConversion.fromString((String)processorFeaturesListValue.name()));
                }
                if (processorFeaturesListValue.value() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Value", StringConversion.fromString((String)processorFeaturesListValue.value()));
                }
                ++processorFeaturesListIndex;
            }
        }
        if (restoreDbInstanceFromS3Request.useDefaultProcessorFeatures() != null) {
            request.addParameter("UseDefaultProcessorFeatures", StringConversion.fromBoolean((Boolean)restoreDbInstanceFromS3Request.useDefaultProcessorFeatures()));
        }
        return request;
    }
}

