/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.rds.model.ProcessorFeature;
import software.amazon.awssdk.services.rds.model.RestoreDbInstanceToPointInTimeRequest;
import software.amazon.awssdk.services.rds.model.Tag;

public class RestoreDbInstanceToPointInTimeRequestMarshaller
implements Marshaller<Request<RestoreDbInstanceToPointInTimeRequest>, RestoreDbInstanceToPointInTimeRequest> {
    public Request<RestoreDbInstanceToPointInTimeRequest> marshall(RestoreDbInstanceToPointInTimeRequest restoreDbInstanceToPointInTimeRequest) {
        if (restoreDbInstanceToPointInTimeRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)restoreDbInstanceToPointInTimeRequest, "RdsClient");
        request.addParameter("Action", "RestoreDBInstanceToPointInTime");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreDbInstanceToPointInTimeRequest.sourceDBInstanceIdentifier() != null) {
            request.addParameter("SourceDBInstanceIdentifier", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.sourceDBInstanceIdentifier()));
        }
        if (restoreDbInstanceToPointInTimeRequest.targetDBInstanceIdentifier() != null) {
            request.addParameter("TargetDBInstanceIdentifier", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.targetDBInstanceIdentifier()));
        }
        if (restoreDbInstanceToPointInTimeRequest.restoreTime() != null) {
            request.addParameter("RestoreTime", StringConversion.fromInstant((Instant)restoreDbInstanceToPointInTimeRequest.restoreTime()));
        }
        if (restoreDbInstanceToPointInTimeRequest.useLatestRestorableTime() != null) {
            request.addParameter("UseLatestRestorableTime", StringConversion.fromBoolean((Boolean)restoreDbInstanceToPointInTimeRequest.useLatestRestorableTime()));
        }
        if (restoreDbInstanceToPointInTimeRequest.dbInstanceClass() != null) {
            request.addParameter("DBInstanceClass", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.dbInstanceClass()));
        }
        if (restoreDbInstanceToPointInTimeRequest.port() != null) {
            request.addParameter("Port", StringConversion.fromInteger((Integer)restoreDbInstanceToPointInTimeRequest.port()));
        }
        if (restoreDbInstanceToPointInTimeRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.availabilityZone()));
        }
        if (restoreDbInstanceToPointInTimeRequest.dbSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.dbSubnetGroupName()));
        }
        if (restoreDbInstanceToPointInTimeRequest.multiAZ() != null) {
            request.addParameter("MultiAZ", StringConversion.fromBoolean((Boolean)restoreDbInstanceToPointInTimeRequest.multiAZ()));
        }
        if (restoreDbInstanceToPointInTimeRequest.publiclyAccessible() != null) {
            request.addParameter("PubliclyAccessible", StringConversion.fromBoolean((Boolean)restoreDbInstanceToPointInTimeRequest.publiclyAccessible()));
        }
        if (restoreDbInstanceToPointInTimeRequest.autoMinorVersionUpgrade() != null) {
            request.addParameter("AutoMinorVersionUpgrade", StringConversion.fromBoolean((Boolean)restoreDbInstanceToPointInTimeRequest.autoMinorVersionUpgrade()));
        }
        if (restoreDbInstanceToPointInTimeRequest.licenseModel() != null) {
            request.addParameter("LicenseModel", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.licenseModel()));
        }
        if (restoreDbInstanceToPointInTimeRequest.dbName() != null) {
            request.addParameter("DBName", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.dbName()));
        }
        if (restoreDbInstanceToPointInTimeRequest.engine() != null) {
            request.addParameter("Engine", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.engine()));
        }
        if (restoreDbInstanceToPointInTimeRequest.iops() != null) {
            request.addParameter("Iops", StringConversion.fromInteger((Integer)restoreDbInstanceToPointInTimeRequest.iops()));
        }
        if (restoreDbInstanceToPointInTimeRequest.optionGroupName() != null) {
            request.addParameter("OptionGroupName", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.optionGroupName()));
        }
        if (restoreDbInstanceToPointInTimeRequest.copyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringConversion.fromBoolean((Boolean)restoreDbInstanceToPointInTimeRequest.copyTagsToSnapshot()));
        }
        if (restoreDbInstanceToPointInTimeRequest.tags().isEmpty() && !(restoreDbInstanceToPointInTimeRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!restoreDbInstanceToPointInTimeRequest.tags().isEmpty() && !(restoreDbInstanceToPointInTimeRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = restoreDbInstanceToPointInTimeRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDbInstanceToPointInTimeRequest.storageType() != null) {
            request.addParameter("StorageType", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.storageType()));
        }
        if (restoreDbInstanceToPointInTimeRequest.tdeCredentialArn() != null) {
            request.addParameter("TdeCredentialArn", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.tdeCredentialArn()));
        }
        if (restoreDbInstanceToPointInTimeRequest.tdeCredentialPassword() != null) {
            request.addParameter("TdeCredentialPassword", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.tdeCredentialPassword()));
        }
        if (restoreDbInstanceToPointInTimeRequest.domain() != null) {
            request.addParameter("Domain", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.domain()));
        }
        if (restoreDbInstanceToPointInTimeRequest.domainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringConversion.fromString((String)restoreDbInstanceToPointInTimeRequest.domainIAMRoleName()));
        }
        if (restoreDbInstanceToPointInTimeRequest.enableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringConversion.fromBoolean((Boolean)restoreDbInstanceToPointInTimeRequest.enableIAMDatabaseAuthentication()));
        }
        if (restoreDbInstanceToPointInTimeRequest.enableCloudwatchLogsExports().isEmpty() && !(restoreDbInstanceToPointInTimeRequest.enableCloudwatchLogsExports() instanceof SdkAutoConstructList)) {
            request.addParameter("EnableCloudwatchLogsExports", "");
        } else if (!restoreDbInstanceToPointInTimeRequest.enableCloudwatchLogsExports().isEmpty() && !(restoreDbInstanceToPointInTimeRequest.enableCloudwatchLogsExports() instanceof SdkAutoConstructList)) {
            List<String> enableCloudwatchLogsExportsList = restoreDbInstanceToPointInTimeRequest.enableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringConversion.fromString((String)enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (restoreDbInstanceToPointInTimeRequest.processorFeatures().isEmpty() && !(restoreDbInstanceToPointInTimeRequest.processorFeatures() instanceof SdkAutoConstructList)) {
            request.addParameter("ProcessorFeatures", "");
        } else if (!restoreDbInstanceToPointInTimeRequest.processorFeatures().isEmpty() && !(restoreDbInstanceToPointInTimeRequest.processorFeatures() instanceof SdkAutoConstructList)) {
            List<ProcessorFeature> processorFeaturesList = restoreDbInstanceToPointInTimeRequest.processorFeatures();
            int processorFeaturesListIndex = 1;
            for (ProcessorFeature processorFeaturesListValue : processorFeaturesList) {
                if (processorFeaturesListValue.name() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Name", StringConversion.fromString((String)processorFeaturesListValue.name()));
                }
                if (processorFeaturesListValue.value() != null) {
                    request.addParameter("ProcessorFeatures.ProcessorFeature." + processorFeaturesListIndex + ".Value", StringConversion.fromString((String)processorFeaturesListValue.value()));
                }
                ++processorFeaturesListIndex;
            }
        }
        if (restoreDbInstanceToPointInTimeRequest.useDefaultProcessorFeatures() != null) {
            request.addParameter("UseDefaultProcessorFeatures", StringConversion.fromBoolean((Boolean)restoreDbInstanceToPointInTimeRequest.useDefaultProcessorFeatures()));
        }
        return request;
    }
}

