/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.ScalingConfigurationInfo;

public class ScalingConfigurationInfoUnmarshaller
implements Unmarshaller<ScalingConfigurationInfo, StaxUnmarshallerContext> {
    private static final ScalingConfigurationInfoUnmarshaller INSTANCE = new ScalingConfigurationInfoUnmarshaller();

    public ScalingConfigurationInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ScalingConfigurationInfo.Builder scalingConfigurationInfo = ScalingConfigurationInfo.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MinCapacity", targetDepth)) {
                    scalingConfigurationInfo.minCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxCapacity", targetDepth)) {
                    scalingConfigurationInfo.maxCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoPause", targetDepth)) {
                    scalingConfigurationInfo.autoPause(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SecondsUntilAutoPause", targetDepth)) continue;
                scalingConfigurationInfo.secondsUntilAutoPause(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ScalingConfigurationInfo)scalingConfigurationInfo.build();
    }

    public static ScalingConfigurationInfoUnmarshaller getInstance() {
        return INSTANCE;
    }
}

