/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.ScalingConfiguration;

public class ScalingConfigurationUnmarshaller
implements Unmarshaller<ScalingConfiguration, StaxUnmarshallerContext> {
    private static final ScalingConfigurationUnmarshaller INSTANCE = new ScalingConfigurationUnmarshaller();

    public ScalingConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ScalingConfiguration.Builder scalingConfiguration = ScalingConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MinCapacity", targetDepth)) {
                    scalingConfiguration.minCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MaxCapacity", targetDepth)) {
                    scalingConfiguration.maxCapacity(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AutoPause", targetDepth)) {
                    scalingConfiguration.autoPause(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("SecondsUntilAutoPause", targetDepth)) continue;
                scalingConfiguration.secondsUntilAutoPause(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ScalingConfiguration)scalingConfiguration.build();
    }

    public static ScalingConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

