/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds;

import java.net.URI;
import java.util.Date;
import software.amazon.awssdk.AmazonClientException;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.Protocol;
import software.amazon.awssdk.RequestConfig;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.AwsCredentials;
import software.amazon.awssdk.handlers.AwsHandlerKeys;
import software.amazon.awssdk.handlers.RequestHandler;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.runtime.endpoint.DefaultServiceEndpointBuilder;
import software.amazon.awssdk.util.AwsHostNameUtils;
import software.amazon.awssdk.util.SdkHttpUtils;
import software.amazon.awssdk.utils.StringUtils;

abstract class PresignRequestHandler<T extends AmazonWebServiceRequest>
extends RequestHandler {
    private static final String SERVICE_NAME = "rds";
    private static final String PARAM_SOURCE_REGION = "SourceRegion";
    private static final String PARAM_DESTINATION_REGION = "DestinationRegion";
    private static final String PARAM_PRESIGNED_URL = "PreSignedUrl";
    private final Class<T> requestClassToPreSign;
    private final Date signingOverrideDate;

    protected PresignRequestHandler(Class<T> requestClassToPreSign) {
        this(requestClassToPreSign, null);
    }

    protected PresignRequestHandler(Class<T> requestClassToPreSign, Date signingOverrideDate) {
        this.requestClassToPreSign = requestClassToPreSign;
        this.signingOverrideDate = signingOverrideDate != null ? new Date(signingOverrideDate.getTime()) : null;
    }

    public SdkHttpFullRequest beforeRequest(SdkHttpFullRequest request) {
        Object originalRequest = ((RequestConfig)request.handlerContext(AwsHandlerKeys.REQUEST_CONFIG)).getOriginalRequest();
        if (!this.requestClassToPreSign.isInstance(originalRequest)) {
            return request;
        }
        if (request.getParameters().containsKey(PARAM_PRESIGNED_URL)) {
            return request;
        }
        PresignableRequest presignableRequest = this.adaptRequest((AmazonWebServiceRequest)this.requestClassToPreSign.cast(originalRequest));
        String sourceRegion = presignableRequest.getSourceRegion();
        if (sourceRegion == null) {
            return request;
        }
        String destinationRegion = AwsHostNameUtils.parseRegion((String)request.getEndpoint().getHost(), (String)SERVICE_NAME);
        SdkHttpFullRequest requestToPresign = (SdkHttpFullRequest)presignableRequest.marshall().removeQueryParameter(PARAM_SOURCE_REGION).queryParameter(PARAM_DESTINATION_REGION, destinationRegion).httpMethod(SdkHttpMethod.GET).endpoint(this.createEndpoint(sourceRegion, SERVICE_NAME)).build();
        AwsCredentials credentials = (AwsCredentials)request.handlerContext(AwsHandlerKeys.AWS_CREDENTIALS);
        requestToPresign = this.presignRequest(requestToPresign, credentials, sourceRegion);
        String presignedUrl = this.generateUrl(requestToPresign);
        presignableRequest.setPreSignedUrl(presignedUrl);
        return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)request.toBuilder()).queryParameter(PARAM_PRESIGNED_URL, presignedUrl).removeQueryParameter(PARAM_SOURCE_REGION).build();
    }

    protected abstract PresignableRequest adaptRequest(T var1);

    private SdkHttpFullRequest presignRequest(SdkHttpFullRequest request, AwsCredentials credentials, String signingRegion) {
        Aws4Signer signer = this.createNewSignerWithRegion(signingRegion);
        return signer.presignRequest(request, credentials, null);
    }

    private Aws4Signer createNewSignerWithRegion(String signingRegion) {
        Aws4Signer signer = new Aws4Signer(true);
        signer.setRegionName(signingRegion);
        signer.setServiceName(SERVICE_NAME);
        signer.setOverrideDate(this.signingOverrideDate);
        return signer;
    }

    private URI createEndpoint(String regionName, String serviceName) {
        Region region = Region.of((String)regionName);
        if (region == null) {
            throw new AmazonClientException("{" + serviceName + ", " + regionName + "} was not found in region metadata. Update to latest version of SDK and try again.");
        }
        return new DefaultServiceEndpointBuilder(SERVICE_NAME, Protocol.HTTPS.toString()).withRegion(region).getServiceEndpoint();
    }

    private String generateUrl(SdkHttpFullRequest request) {
        URI endpoint = request.getEndpoint();
        String uri = SdkHttpUtils.appendUri((String)endpoint.toString(), (String)request.getResourcePath(), (boolean)true);
        String encodedParams = SdkHttpUtils.encodeParameters((SdkHttpRequest)request);
        if (!StringUtils.isEmpty((CharSequence)encodedParams)) {
            uri = uri + "?" + encodedParams;
        }
        return uri;
    }

    protected static interface PresignableRequest {
        public void setPreSignedUrl(String var1);

        public String getSourceRegion();

        public SdkHttpFullRequest.Builder marshall();
    }
}

