/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.DBClusterMember;
import software.amazon.awssdk.services.rds.model.DBClusterMemberListCopier;
import software.amazon.awssdk.services.rds.model.DBClusterOptionGroupMembershipsCopier;
import software.amazon.awssdk.services.rds.model.DBClusterOptionGroupStatus;
import software.amazon.awssdk.services.rds.model.DBClusterRole;
import software.amazon.awssdk.services.rds.model.DBClusterRolesCopier;
import software.amazon.awssdk.services.rds.model.ReadReplicaIdentifierListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBCluster
implements ToCopyableBuilder<Builder, DBCluster> {
    private final Integer allocatedStorage;
    private final List<String> availabilityZones;
    private final Integer backupRetentionPeriod;
    private final String characterSetName;
    private final String databaseName;
    private final String dbClusterIdentifier;
    private final String dbClusterParameterGroup;
    private final String dbSubnetGroup;
    private final String status;
    private final String percentProgress;
    private final Instant earliestRestorableTime;
    private final String endpoint;
    private final String readerEndpoint;
    private final Boolean multiAZ;
    private final String engine;
    private final String engineVersion;
    private final Instant latestRestorableTime;
    private final Integer port;
    private final String masterUsername;
    private final List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final String replicationSourceIdentifier;
    private final List<String> readReplicaIdentifiers;
    private final List<DBClusterMember> dbClusterMembers;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final String hostedZoneId;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String dbClusterResourceId;
    private final String dbClusterArn;
    private final List<DBClusterRole> associatedRoles;
    private final Boolean iamDatabaseAuthenticationEnabled;
    private final String cloneGroupId;
    private final Instant clusterCreateTime;

    private DBCluster(BuilderImpl builder) {
        this.allocatedStorage = builder.allocatedStorage;
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroup = builder.dbClusterParameterGroup;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.status = builder.status;
        this.percentProgress = builder.percentProgress;
        this.earliestRestorableTime = builder.earliestRestorableTime;
        this.endpoint = builder.endpoint;
        this.readerEndpoint = builder.readerEndpoint;
        this.multiAZ = builder.multiAZ;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.dbClusterOptionGroupMemberships = builder.dbClusterOptionGroupMemberships;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.readReplicaIdentifiers = builder.readReplicaIdentifiers;
        this.dbClusterMembers = builder.dbClusterMembers;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.hostedZoneId = builder.hostedZoneId;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.dbClusterResourceId = builder.dbClusterResourceId;
        this.dbClusterArn = builder.dbClusterArn;
        this.associatedRoles = builder.associatedRoles;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.cloneGroupId = builder.cloneGroupId;
        this.clusterCreateTime = builder.clusterCreateTime;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public String characterSetName() {
        return this.characterSetName;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String dbClusterParameterGroup() {
        return this.dbClusterParameterGroup;
    }

    public String dbSubnetGroup() {
        return this.dbSubnetGroup;
    }

    public String status() {
        return this.status;
    }

    public String percentProgress() {
        return this.percentProgress;
    }

    public Instant earliestRestorableTime() {
        return this.earliestRestorableTime;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String readerEndpoint() {
        return this.readerEndpoint;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engine() {
        return this.engine;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Instant latestRestorableTime() {
        return this.latestRestorableTime;
    }

    public Integer port() {
        return this.port;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships() {
        return this.dbClusterOptionGroupMemberships;
    }

    public String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public String replicationSourceIdentifier() {
        return this.replicationSourceIdentifier;
    }

    public List<String> readReplicaIdentifiers() {
        return this.readReplicaIdentifiers;
    }

    public List<DBClusterMember> dbClusterMembers() {
        return this.dbClusterMembers;
    }

    public List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public String hostedZoneId() {
        return this.hostedZoneId;
    }

    public Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public String dbClusterResourceId() {
        return this.dbClusterResourceId;
    }

    public String dbClusterArn() {
        return this.dbClusterArn;
    }

    public List<DBClusterRole> associatedRoles() {
        return this.associatedRoles;
    }

    public Boolean iamDatabaseAuthenticationEnabled() {
        return this.iamDatabaseAuthenticationEnabled;
    }

    public String cloneGroupId() {
        return this.cloneGroupId;
    }

    public Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.allocatedStorage() == null ? 0 : this.allocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZones() == null ? 0 : this.availabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.backupRetentionPeriod() == null ? 0 : this.backupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.characterSetName() == null ? 0 : this.characterSetName().hashCode());
        hashCode = 31 * hashCode + (this.databaseName() == null ? 0 : this.databaseName().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterIdentifier() == null ? 0 : this.dbClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterParameterGroup() == null ? 0 : this.dbClusterParameterGroup().hashCode());
        hashCode = 31 * hashCode + (this.dbSubnetGroup() == null ? 0 : this.dbSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.percentProgress() == null ? 0 : this.percentProgress().hashCode());
        hashCode = 31 * hashCode + (this.earliestRestorableTime() == null ? 0 : this.earliestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.endpoint() == null ? 0 : this.endpoint().hashCode());
        hashCode = 31 * hashCode + (this.readerEndpoint() == null ? 0 : this.readerEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.multiAZ() == null ? 0 : this.multiAZ().hashCode());
        hashCode = 31 * hashCode + (this.engine() == null ? 0 : this.engine().hashCode());
        hashCode = 31 * hashCode + (this.engineVersion() == null ? 0 : this.engineVersion().hashCode());
        hashCode = 31 * hashCode + (this.latestRestorableTime() == null ? 0 : this.latestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.masterUsername() == null ? 0 : this.masterUsername().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterOptionGroupMemberships() == null ? 0 : this.dbClusterOptionGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.preferredBackupWindow() == null ? 0 : this.preferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.preferredMaintenanceWindow() == null ? 0 : this.preferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.replicationSourceIdentifier() == null ? 0 : this.replicationSourceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.readReplicaIdentifiers() == null ? 0 : this.readReplicaIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterMembers() == null ? 0 : this.dbClusterMembers().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroups() == null ? 0 : this.vpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.hostedZoneId() == null ? 0 : this.hostedZoneId().hashCode());
        hashCode = 31 * hashCode + (this.storageEncrypted() == null ? 0 : this.storageEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.kmsKeyId() == null ? 0 : this.kmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterResourceId() == null ? 0 : this.dbClusterResourceId().hashCode());
        hashCode = 31 * hashCode + (this.dbClusterArn() == null ? 0 : this.dbClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.associatedRoles() == null ? 0 : this.associatedRoles().hashCode());
        hashCode = 31 * hashCode + (this.iamDatabaseAuthenticationEnabled() == null ? 0 : this.iamDatabaseAuthenticationEnabled().hashCode());
        hashCode = 31 * hashCode + (this.cloneGroupId() == null ? 0 : this.cloneGroupId().hashCode());
        hashCode = 31 * hashCode + (this.clusterCreateTime() == null ? 0 : this.clusterCreateTime().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBCluster)) {
            return false;
        }
        DBCluster other = (DBCluster)obj;
        if (other.allocatedStorage() == null ^ this.allocatedStorage() == null) {
            return false;
        }
        if (other.allocatedStorage() != null && !other.allocatedStorage().equals(this.allocatedStorage())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.backupRetentionPeriod() == null ^ this.backupRetentionPeriod() == null) {
            return false;
        }
        if (other.backupRetentionPeriod() != null && !other.backupRetentionPeriod().equals(this.backupRetentionPeriod())) {
            return false;
        }
        if (other.characterSetName() == null ^ this.characterSetName() == null) {
            return false;
        }
        if (other.characterSetName() != null && !other.characterSetName().equals(this.characterSetName())) {
            return false;
        }
        if (other.databaseName() == null ^ this.databaseName() == null) {
            return false;
        }
        if (other.databaseName() != null && !other.databaseName().equals(this.databaseName())) {
            return false;
        }
        if (other.dbClusterIdentifier() == null ^ this.dbClusterIdentifier() == null) {
            return false;
        }
        if (other.dbClusterIdentifier() != null && !other.dbClusterIdentifier().equals(this.dbClusterIdentifier())) {
            return false;
        }
        if (other.dbClusterParameterGroup() == null ^ this.dbClusterParameterGroup() == null) {
            return false;
        }
        if (other.dbClusterParameterGroup() != null && !other.dbClusterParameterGroup().equals(this.dbClusterParameterGroup())) {
            return false;
        }
        if (other.dbSubnetGroup() == null ^ this.dbSubnetGroup() == null) {
            return false;
        }
        if (other.dbSubnetGroup() != null && !other.dbSubnetGroup().equals(this.dbSubnetGroup())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.percentProgress() == null ^ this.percentProgress() == null) {
            return false;
        }
        if (other.percentProgress() != null && !other.percentProgress().equals(this.percentProgress())) {
            return false;
        }
        if (other.earliestRestorableTime() == null ^ this.earliestRestorableTime() == null) {
            return false;
        }
        if (other.earliestRestorableTime() != null && !other.earliestRestorableTime().equals(this.earliestRestorableTime())) {
            return false;
        }
        if (other.endpoint() == null ^ this.endpoint() == null) {
            return false;
        }
        if (other.endpoint() != null && !other.endpoint().equals(this.endpoint())) {
            return false;
        }
        if (other.readerEndpoint() == null ^ this.readerEndpoint() == null) {
            return false;
        }
        if (other.readerEndpoint() != null && !other.readerEndpoint().equals(this.readerEndpoint())) {
            return false;
        }
        if (other.multiAZ() == null ^ this.multiAZ() == null) {
            return false;
        }
        if (other.multiAZ() != null && !other.multiAZ().equals(this.multiAZ())) {
            return false;
        }
        if (other.engine() == null ^ this.engine() == null) {
            return false;
        }
        if (other.engine() != null && !other.engine().equals(this.engine())) {
            return false;
        }
        if (other.engineVersion() == null ^ this.engineVersion() == null) {
            return false;
        }
        if (other.engineVersion() != null && !other.engineVersion().equals(this.engineVersion())) {
            return false;
        }
        if (other.latestRestorableTime() == null ^ this.latestRestorableTime() == null) {
            return false;
        }
        if (other.latestRestorableTime() != null && !other.latestRestorableTime().equals(this.latestRestorableTime())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.masterUsername() == null ^ this.masterUsername() == null) {
            return false;
        }
        if (other.masterUsername() != null && !other.masterUsername().equals(this.masterUsername())) {
            return false;
        }
        if (other.dbClusterOptionGroupMemberships() == null ^ this.dbClusterOptionGroupMemberships() == null) {
            return false;
        }
        if (other.dbClusterOptionGroupMemberships() != null && !other.dbClusterOptionGroupMemberships().equals(this.dbClusterOptionGroupMemberships())) {
            return false;
        }
        if (other.preferredBackupWindow() == null ^ this.preferredBackupWindow() == null) {
            return false;
        }
        if (other.preferredBackupWindow() != null && !other.preferredBackupWindow().equals(this.preferredBackupWindow())) {
            return false;
        }
        if (other.preferredMaintenanceWindow() == null ^ this.preferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.preferredMaintenanceWindow() != null && !other.preferredMaintenanceWindow().equals(this.preferredMaintenanceWindow())) {
            return false;
        }
        if (other.replicationSourceIdentifier() == null ^ this.replicationSourceIdentifier() == null) {
            return false;
        }
        if (other.replicationSourceIdentifier() != null && !other.replicationSourceIdentifier().equals(this.replicationSourceIdentifier())) {
            return false;
        }
        if (other.readReplicaIdentifiers() == null ^ this.readReplicaIdentifiers() == null) {
            return false;
        }
        if (other.readReplicaIdentifiers() != null && !other.readReplicaIdentifiers().equals(this.readReplicaIdentifiers())) {
            return false;
        }
        if (other.dbClusterMembers() == null ^ this.dbClusterMembers() == null) {
            return false;
        }
        if (other.dbClusterMembers() != null && !other.dbClusterMembers().equals(this.dbClusterMembers())) {
            return false;
        }
        if (other.vpcSecurityGroups() == null ^ this.vpcSecurityGroups() == null) {
            return false;
        }
        if (other.vpcSecurityGroups() != null && !other.vpcSecurityGroups().equals(this.vpcSecurityGroups())) {
            return false;
        }
        if (other.hostedZoneId() == null ^ this.hostedZoneId() == null) {
            return false;
        }
        if (other.hostedZoneId() != null && !other.hostedZoneId().equals(this.hostedZoneId())) {
            return false;
        }
        if (other.storageEncrypted() == null ^ this.storageEncrypted() == null) {
            return false;
        }
        if (other.storageEncrypted() != null && !other.storageEncrypted().equals(this.storageEncrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.dbClusterResourceId() == null ^ this.dbClusterResourceId() == null) {
            return false;
        }
        if (other.dbClusterResourceId() != null && !other.dbClusterResourceId().equals(this.dbClusterResourceId())) {
            return false;
        }
        if (other.dbClusterArn() == null ^ this.dbClusterArn() == null) {
            return false;
        }
        if (other.dbClusterArn() != null && !other.dbClusterArn().equals(this.dbClusterArn())) {
            return false;
        }
        if (other.associatedRoles() == null ^ this.associatedRoles() == null) {
            return false;
        }
        if (other.associatedRoles() != null && !other.associatedRoles().equals(this.associatedRoles())) {
            return false;
        }
        if (other.iamDatabaseAuthenticationEnabled() == null ^ this.iamDatabaseAuthenticationEnabled() == null) {
            return false;
        }
        if (other.iamDatabaseAuthenticationEnabled() != null && !other.iamDatabaseAuthenticationEnabled().equals(this.iamDatabaseAuthenticationEnabled())) {
            return false;
        }
        if (other.cloneGroupId() == null ^ this.cloneGroupId() == null) {
            return false;
        }
        if (other.cloneGroupId() != null && !other.cloneGroupId().equals(this.cloneGroupId())) {
            return false;
        }
        if (other.clusterCreateTime() == null ^ this.clusterCreateTime() == null) {
            return false;
        }
        return other.clusterCreateTime() == null || other.clusterCreateTime().equals(this.clusterCreateTime());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.allocatedStorage()).append(",");
        }
        if (this.availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.availabilityZones()).append(",");
        }
        if (this.backupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.backupRetentionPeriod()).append(",");
        }
        if (this.characterSetName() != null) {
            sb.append("CharacterSetName: ").append(this.characterSetName()).append(",");
        }
        if (this.databaseName() != null) {
            sb.append("DatabaseName: ").append(this.databaseName()).append(",");
        }
        if (this.dbClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.dbClusterIdentifier()).append(",");
        }
        if (this.dbClusterParameterGroup() != null) {
            sb.append("DBClusterParameterGroup: ").append(this.dbClusterParameterGroup()).append(",");
        }
        if (this.dbSubnetGroup() != null) {
            sb.append("DBSubnetGroup: ").append(this.dbSubnetGroup()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.percentProgress() != null) {
            sb.append("PercentProgress: ").append(this.percentProgress()).append(",");
        }
        if (this.earliestRestorableTime() != null) {
            sb.append("EarliestRestorableTime: ").append(this.earliestRestorableTime()).append(",");
        }
        if (this.endpoint() != null) {
            sb.append("Endpoint: ").append(this.endpoint()).append(",");
        }
        if (this.readerEndpoint() != null) {
            sb.append("ReaderEndpoint: ").append(this.readerEndpoint()).append(",");
        }
        if (this.multiAZ() != null) {
            sb.append("MultiAZ: ").append(this.multiAZ()).append(",");
        }
        if (this.engine() != null) {
            sb.append("Engine: ").append(this.engine()).append(",");
        }
        if (this.engineVersion() != null) {
            sb.append("EngineVersion: ").append(this.engineVersion()).append(",");
        }
        if (this.latestRestorableTime() != null) {
            sb.append("LatestRestorableTime: ").append(this.latestRestorableTime()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.masterUsername() != null) {
            sb.append("MasterUsername: ").append(this.masterUsername()).append(",");
        }
        if (this.dbClusterOptionGroupMemberships() != null) {
            sb.append("DBClusterOptionGroupMemberships: ").append(this.dbClusterOptionGroupMemberships()).append(",");
        }
        if (this.preferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.preferredBackupWindow()).append(",");
        }
        if (this.preferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.preferredMaintenanceWindow()).append(",");
        }
        if (this.replicationSourceIdentifier() != null) {
            sb.append("ReplicationSourceIdentifier: ").append(this.replicationSourceIdentifier()).append(",");
        }
        if (this.readReplicaIdentifiers() != null) {
            sb.append("ReadReplicaIdentifiers: ").append(this.readReplicaIdentifiers()).append(",");
        }
        if (this.dbClusterMembers() != null) {
            sb.append("DBClusterMembers: ").append(this.dbClusterMembers()).append(",");
        }
        if (this.vpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: ").append(this.vpcSecurityGroups()).append(",");
        }
        if (this.hostedZoneId() != null) {
            sb.append("HostedZoneId: ").append(this.hostedZoneId()).append(",");
        }
        if (this.storageEncrypted() != null) {
            sb.append("StorageEncrypted: ").append(this.storageEncrypted()).append(",");
        }
        if (this.kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.kmsKeyId()).append(",");
        }
        if (this.dbClusterResourceId() != null) {
            sb.append("DbClusterResourceId: ").append(this.dbClusterResourceId()).append(",");
        }
        if (this.dbClusterArn() != null) {
            sb.append("DBClusterArn: ").append(this.dbClusterArn()).append(",");
        }
        if (this.associatedRoles() != null) {
            sb.append("AssociatedRoles: ").append(this.associatedRoles()).append(",");
        }
        if (this.iamDatabaseAuthenticationEnabled() != null) {
            sb.append("IAMDatabaseAuthenticationEnabled: ").append(this.iamDatabaseAuthenticationEnabled()).append(",");
        }
        if (this.cloneGroupId() != null) {
            sb.append("CloneGroupId: ").append(this.cloneGroupId()).append(",");
        }
        if (this.clusterCreateTime() != null) {
            sb.append("ClusterCreateTime: ").append(this.clusterCreateTime()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer allocatedStorage;
        private List<String> availabilityZones;
        private Integer backupRetentionPeriod;
        private String characterSetName;
        private String databaseName;
        private String dbClusterIdentifier;
        private String dbClusterParameterGroup;
        private String dbSubnetGroup;
        private String status;
        private String percentProgress;
        private Instant earliestRestorableTime;
        private String endpoint;
        private String readerEndpoint;
        private Boolean multiAZ;
        private String engine;
        private String engineVersion;
        private Instant latestRestorableTime;
        private Integer port;
        private String masterUsername;
        private List<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private String replicationSourceIdentifier;
        private List<String> readReplicaIdentifiers;
        private List<DBClusterMember> dbClusterMembers;
        private List<VpcSecurityGroupMembership> vpcSecurityGroups;
        private String hostedZoneId;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String dbClusterResourceId;
        private String dbClusterArn;
        private List<DBClusterRole> associatedRoles;
        private Boolean iamDatabaseAuthenticationEnabled;
        private String cloneGroupId;
        private Instant clusterCreateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DBCluster model) {
            this.setAllocatedStorage(model.allocatedStorage);
            this.setAvailabilityZones(model.availabilityZones);
            this.setBackupRetentionPeriod(model.backupRetentionPeriod);
            this.setCharacterSetName(model.characterSetName);
            this.setDatabaseName(model.databaseName);
            this.setDBClusterIdentifier(model.dbClusterIdentifier);
            this.setDBClusterParameterGroup(model.dbClusterParameterGroup);
            this.setDBSubnetGroup(model.dbSubnetGroup);
            this.setStatus(model.status);
            this.setPercentProgress(model.percentProgress);
            this.setEarliestRestorableTime(model.earliestRestorableTime);
            this.setEndpoint(model.endpoint);
            this.setReaderEndpoint(model.readerEndpoint);
            this.setMultiAZ(model.multiAZ);
            this.setEngine(model.engine);
            this.setEngineVersion(model.engineVersion);
            this.setLatestRestorableTime(model.latestRestorableTime);
            this.setPort(model.port);
            this.setMasterUsername(model.masterUsername);
            this.setDBClusterOptionGroupMemberships(model.dbClusterOptionGroupMemberships);
            this.setPreferredBackupWindow(model.preferredBackupWindow);
            this.setPreferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.setReplicationSourceIdentifier(model.replicationSourceIdentifier);
            this.setReadReplicaIdentifiers(model.readReplicaIdentifiers);
            this.setDBClusterMembers(model.dbClusterMembers);
            this.setVpcSecurityGroups(model.vpcSecurityGroups);
            this.setHostedZoneId(model.hostedZoneId);
            this.setStorageEncrypted(model.storageEncrypted);
            this.setKmsKeyId(model.kmsKeyId);
            this.setDbClusterResourceId(model.dbClusterResourceId);
            this.setDBClusterArn(model.dbClusterArn);
            this.setAssociatedRoles(model.associatedRoles);
            this.setIAMDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            this.setCloneGroupId(model.cloneGroupId);
            this.setClusterCreateTime(model.clusterCreateTime);
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @SafeVarargs
        public final void setAvailabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getDBClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDBClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDBClusterParameterGroup() {
            return this.dbClusterParameterGroup;
        }

        @Override
        public final Builder dbClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
            return this;
        }

        public final void setDBClusterParameterGroup(String dbClusterParameterGroup) {
            this.dbClusterParameterGroup = dbClusterParameterGroup;
        }

        public final String getDBSubnetGroup() {
            return this.dbSubnetGroup;
        }

        @Override
        public final Builder dbSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final void setDBSubnetGroup(String dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getPercentProgress() {
            return this.percentProgress;
        }

        @Override
        public final Builder percentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final void setPercentProgress(String percentProgress) {
            this.percentProgress = percentProgress;
        }

        public final Instant getEarliestRestorableTime() {
            return this.earliestRestorableTime;
        }

        @Override
        public final Builder earliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
            return this;
        }

        public final void setEarliestRestorableTime(Instant earliestRestorableTime) {
            this.earliestRestorableTime = earliestRestorableTime;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getReaderEndpoint() {
            return this.readerEndpoint;
        }

        @Override
        public final Builder readerEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
            return this;
        }

        public final void setReaderEndpoint(String readerEndpoint) {
            this.readerEndpoint = readerEndpoint;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Instant getLatestRestorableTime() {
            return this.latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final void setLatestRestorableTime(Instant latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final Collection<DBClusterOptionGroupStatus> getDBClusterOptionGroupMemberships() {
            return this.dbClusterOptionGroupMemberships;
        }

        @Override
        public final Builder dbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier.copy(dbClusterOptionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships(Arrays.asList(dbClusterOptionGroupMemberships));
            return this;
        }

        public final void setDBClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships = DBClusterOptionGroupMembershipsCopier.copy(dbClusterOptionGroupMemberships);
        }

        @SafeVarargs
        public final void setDBClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... dbClusterOptionGroupMemberships) {
            this.dbClusterOptionGroupMemberships(Arrays.asList(dbClusterOptionGroupMemberships));
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getReplicationSourceIdentifier() {
            return this.replicationSourceIdentifier;
        }

        @Override
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        public final Collection<String> getReadReplicaIdentifiers() {
            return this.readReplicaIdentifiers;
        }

        @Override
        public final Builder readReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaIdentifiers(String ... readReplicaIdentifiers) {
            this.readReplicaIdentifiers(Arrays.asList(readReplicaIdentifiers));
            return this;
        }

        public final void setReadReplicaIdentifiers(Collection<String> readReplicaIdentifiers) {
            this.readReplicaIdentifiers = ReadReplicaIdentifierListCopier.copy(readReplicaIdentifiers);
        }

        @SafeVarargs
        public final void setReadReplicaIdentifiers(String ... readReplicaIdentifiers) {
            this.readReplicaIdentifiers(Arrays.asList(readReplicaIdentifiers));
        }

        public final Collection<DBClusterMember> getDBClusterMembers() {
            return this.dbClusterMembers;
        }

        @Override
        public final Builder dbClusterMembers(Collection<DBClusterMember> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copy(dbClusterMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbClusterMembers(DBClusterMember ... dbClusterMembers) {
            this.dbClusterMembers(Arrays.asList(dbClusterMembers));
            return this;
        }

        public final void setDBClusterMembers(Collection<DBClusterMember> dbClusterMembers) {
            this.dbClusterMembers = DBClusterMemberListCopier.copy(dbClusterMembers);
        }

        @SafeVarargs
        public final void setDBClusterMembers(DBClusterMember ... dbClusterMembers) {
            this.dbClusterMembers(Arrays.asList(dbClusterMembers));
        }

        public final Collection<VpcSecurityGroupMembership> getVpcSecurityGroups() {
            return this.vpcSecurityGroups;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
        }

        @SafeVarargs
        public final void setVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getDbClusterResourceId() {
            return this.dbClusterResourceId;
        }

        @Override
        public final Builder dbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
            return this;
        }

        public final void setDbClusterResourceId(String dbClusterResourceId) {
            this.dbClusterResourceId = dbClusterResourceId;
        }

        public final String getDBClusterArn() {
            return this.dbClusterArn;
        }

        @Override
        public final Builder dbClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
            return this;
        }

        public final void setDBClusterArn(String dbClusterArn) {
            this.dbClusterArn = dbClusterArn;
        }

        public final Collection<DBClusterRole> getAssociatedRoles() {
            return this.associatedRoles;
        }

        @Override
        public final Builder associatedRoles(Collection<DBClusterRole> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(DBClusterRole ... associatedRoles) {
            this.associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        public final void setAssociatedRoles(Collection<DBClusterRole> associatedRoles) {
            this.associatedRoles = DBClusterRolesCopier.copy(associatedRoles);
        }

        @SafeVarargs
        public final void setAssociatedRoles(DBClusterRole ... associatedRoles) {
            this.associatedRoles(Arrays.asList(associatedRoles));
        }

        public final Boolean getIAMDatabaseAuthenticationEnabled() {
            return this.iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final void setIAMDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        public final String getCloneGroupId() {
            return this.cloneGroupId;
        }

        @Override
        public final Builder cloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
            return this;
        }

        public final void setCloneGroupId(String cloneGroupId) {
            this.cloneGroupId = cloneGroupId;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public DBCluster build() {
            return new DBCluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBCluster> {
        public Builder allocatedStorage(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder characterSetName(String var1);

        public Builder databaseName(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterParameterGroup(String var1);

        public Builder dbSubnetGroup(String var1);

        public Builder status(String var1);

        public Builder percentProgress(String var1);

        public Builder earliestRestorableTime(Instant var1);

        public Builder endpoint(String var1);

        public Builder readerEndpoint(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder latestRestorableTime(Instant var1);

        public Builder port(Integer var1);

        public Builder masterUsername(String var1);

        public Builder dbClusterOptionGroupMemberships(Collection<DBClusterOptionGroupStatus> var1);

        public Builder dbClusterOptionGroupMemberships(DBClusterOptionGroupStatus ... var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder replicationSourceIdentifier(String var1);

        public Builder readReplicaIdentifiers(Collection<String> var1);

        public Builder readReplicaIdentifiers(String ... var1);

        public Builder dbClusterMembers(Collection<DBClusterMember> var1);

        public Builder dbClusterMembers(DBClusterMember ... var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder hostedZoneId(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder dbClusterResourceId(String var1);

        public Builder dbClusterArn(String var1);

        public Builder associatedRoles(Collection<DBClusterRole> var1);

        public Builder associatedRoles(DBClusterRole ... var1);

        public Builder iamDatabaseAuthenticationEnabled(Boolean var1);

        public Builder cloneGroupId(String var1);

        public Builder clusterCreateTime(Instant var1);
    }
}

