/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.DBSnapshotAttribute;
import software.amazon.awssdk.services.rds.model.DBSnapshotAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DBSnapshotAttributesResult
implements ToCopyableBuilder<Builder, DBSnapshotAttributesResult> {
    private final String dbSnapshotIdentifier;
    private final List<DBSnapshotAttribute> dbSnapshotAttributes;

    private DBSnapshotAttributesResult(BuilderImpl builder) {
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.dbSnapshotAttributes = builder.dbSnapshotAttributes;
    }

    public String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public List<DBSnapshotAttribute> dbSnapshotAttributes() {
        return this.dbSnapshotAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.dbSnapshotIdentifier() == null ? 0 : this.dbSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.dbSnapshotAttributes() == null ? 0 : this.dbSnapshotAttributes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBSnapshotAttributesResult)) {
            return false;
        }
        DBSnapshotAttributesResult other = (DBSnapshotAttributesResult)obj;
        if (other.dbSnapshotIdentifier() == null ^ this.dbSnapshotIdentifier() == null) {
            return false;
        }
        if (other.dbSnapshotIdentifier() != null && !other.dbSnapshotIdentifier().equals(this.dbSnapshotIdentifier())) {
            return false;
        }
        if (other.dbSnapshotAttributes() == null ^ this.dbSnapshotAttributes() == null) {
            return false;
        }
        return other.dbSnapshotAttributes() == null || other.dbSnapshotAttributes().equals(this.dbSnapshotAttributes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dbSnapshotIdentifier() != null) {
            sb.append("DBSnapshotIdentifier: ").append(this.dbSnapshotIdentifier()).append(",");
        }
        if (this.dbSnapshotAttributes() != null) {
            sb.append("DBSnapshotAttributes: ").append(this.dbSnapshotAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private List<DBSnapshotAttribute> dbSnapshotAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(DBSnapshotAttributesResult model) {
            this.setDBSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.setDBSnapshotAttributes(model.dbSnapshotAttributes);
        }

        public final String getDBSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        @Override
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final void setDBSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        public final Collection<DBSnapshotAttribute> getDBSnapshotAttributes() {
            return this.dbSnapshotAttributes;
        }

        @Override
        public final Builder dbSnapshotAttributes(Collection<DBSnapshotAttribute> dbSnapshotAttributes) {
            this.dbSnapshotAttributes = DBSnapshotAttributeListCopier.copy(dbSnapshotAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSnapshotAttributes(DBSnapshotAttribute ... dbSnapshotAttributes) {
            this.dbSnapshotAttributes(Arrays.asList(dbSnapshotAttributes));
            return this;
        }

        public final void setDBSnapshotAttributes(Collection<DBSnapshotAttribute> dbSnapshotAttributes) {
            this.dbSnapshotAttributes = DBSnapshotAttributeListCopier.copy(dbSnapshotAttributes);
        }

        @SafeVarargs
        public final void setDBSnapshotAttributes(DBSnapshotAttribute ... dbSnapshotAttributes) {
            this.dbSnapshotAttributes(Arrays.asList(dbSnapshotAttributes));
        }

        public DBSnapshotAttributesResult build() {
            return new DBSnapshotAttributesResult(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DBSnapshotAttributesResult> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder dbSnapshotAttributes(Collection<DBSnapshotAttribute> var1);

        public Builder dbSnapshotAttributes(DBSnapshotAttribute ... var1);
    }
}

