/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.EventCategoriesListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EventCategoriesMap
implements ToCopyableBuilder<Builder, EventCategoriesMap> {
    private final String sourceType;
    private final List<String> eventCategories;

    private EventCategoriesMap(BuilderImpl builder) {
        this.sourceType = builder.sourceType;
        this.eventCategories = builder.eventCategories;
    }

    public String sourceType() {
        return this.sourceType;
    }

    public List<String> eventCategories() {
        return this.eventCategories;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceType() == null ? 0 : this.sourceType().hashCode());
        hashCode = 31 * hashCode + (this.eventCategories() == null ? 0 : this.eventCategories().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventCategoriesMap)) {
            return false;
        }
        EventCategoriesMap other = (EventCategoriesMap)obj;
        if (other.sourceType() == null ^ this.sourceType() == null) {
            return false;
        }
        if (other.sourceType() != null && !other.sourceType().equals(this.sourceType())) {
            return false;
        }
        if (other.eventCategories() == null ^ this.eventCategories() == null) {
            return false;
        }
        return other.eventCategories() == null || other.eventCategories().equals(this.eventCategories());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceType() != null) {
            sb.append("SourceType: ").append(this.sourceType()).append(",");
        }
        if (this.eventCategories() != null) {
            sb.append("EventCategories: ").append(this.eventCategories()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceType;
        private List<String> eventCategories;

        private BuilderImpl() {
        }

        private BuilderImpl(EventCategoriesMap model) {
            this.setSourceType(model.sourceType);
            this.setEventCategories(model.eventCategories);
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        public final Collection<String> getEventCategories() {
            return this.eventCategories;
        }

        @Override
        public final Builder eventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
            return this;
        }

        public final void setEventCategories(Collection<String> eventCategories) {
            this.eventCategories = EventCategoriesListCopier.copy(eventCategories);
        }

        @SafeVarargs
        public final void setEventCategories(String ... eventCategories) {
            this.eventCategories(Arrays.asList(eventCategories));
        }

        public EventCategoriesMap build() {
            return new EventCategoriesMap(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EventCategoriesMap> {
        public Builder sourceType(String var1);

        public Builder eventCategories(Collection<String> var1);

        public Builder eventCategories(String ... var1);
    }
}

