/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupNameListCopier;
import software.amazon.awssdk.services.rds.model.OptionSetting;
import software.amazon.awssdk.services.rds.model.OptionSettingsListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OptionConfiguration
implements ToCopyableBuilder<Builder, OptionConfiguration> {
    private final String optionName;
    private final Integer port;
    private final String optionVersion;
    private final List<String> dbSecurityGroupMemberships;
    private final List<String> vpcSecurityGroupMemberships;
    private final List<OptionSetting> optionSettings;

    private OptionConfiguration(BuilderImpl builder) {
        this.optionName = builder.optionName;
        this.port = builder.port;
        this.optionVersion = builder.optionVersion;
        this.dbSecurityGroupMemberships = builder.dbSecurityGroupMemberships;
        this.vpcSecurityGroupMemberships = builder.vpcSecurityGroupMemberships;
        this.optionSettings = builder.optionSettings;
    }

    public String optionName() {
        return this.optionName;
    }

    public Integer port() {
        return this.port;
    }

    public String optionVersion() {
        return this.optionVersion;
    }

    public List<String> dbSecurityGroupMemberships() {
        return this.dbSecurityGroupMemberships;
    }

    public List<String> vpcSecurityGroupMemberships() {
        return this.vpcSecurityGroupMemberships;
    }

    public List<OptionSetting> optionSettings() {
        return this.optionSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.optionName() == null ? 0 : this.optionName().hashCode());
        hashCode = 31 * hashCode + (this.port() == null ? 0 : this.port().hashCode());
        hashCode = 31 * hashCode + (this.optionVersion() == null ? 0 : this.optionVersion().hashCode());
        hashCode = 31 * hashCode + (this.dbSecurityGroupMemberships() == null ? 0 : this.dbSecurityGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.vpcSecurityGroupMemberships() == null ? 0 : this.vpcSecurityGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.optionSettings() == null ? 0 : this.optionSettings().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionConfiguration)) {
            return false;
        }
        OptionConfiguration other = (OptionConfiguration)obj;
        if (other.optionName() == null ^ this.optionName() == null) {
            return false;
        }
        if (other.optionName() != null && !other.optionName().equals(this.optionName())) {
            return false;
        }
        if (other.port() == null ^ this.port() == null) {
            return false;
        }
        if (other.port() != null && !other.port().equals(this.port())) {
            return false;
        }
        if (other.optionVersion() == null ^ this.optionVersion() == null) {
            return false;
        }
        if (other.optionVersion() != null && !other.optionVersion().equals(this.optionVersion())) {
            return false;
        }
        if (other.dbSecurityGroupMemberships() == null ^ this.dbSecurityGroupMemberships() == null) {
            return false;
        }
        if (other.dbSecurityGroupMemberships() != null && !other.dbSecurityGroupMemberships().equals(this.dbSecurityGroupMemberships())) {
            return false;
        }
        if (other.vpcSecurityGroupMemberships() == null ^ this.vpcSecurityGroupMemberships() == null) {
            return false;
        }
        if (other.vpcSecurityGroupMemberships() != null && !other.vpcSecurityGroupMemberships().equals(this.vpcSecurityGroupMemberships())) {
            return false;
        }
        if (other.optionSettings() == null ^ this.optionSettings() == null) {
            return false;
        }
        return other.optionSettings() == null || other.optionSettings().equals(this.optionSettings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.optionName() != null) {
            sb.append("OptionName: ").append(this.optionName()).append(",");
        }
        if (this.port() != null) {
            sb.append("Port: ").append(this.port()).append(",");
        }
        if (this.optionVersion() != null) {
            sb.append("OptionVersion: ").append(this.optionVersion()).append(",");
        }
        if (this.dbSecurityGroupMemberships() != null) {
            sb.append("DBSecurityGroupMemberships: ").append(this.dbSecurityGroupMemberships()).append(",");
        }
        if (this.vpcSecurityGroupMemberships() != null) {
            sb.append("VpcSecurityGroupMemberships: ").append(this.vpcSecurityGroupMemberships()).append(",");
        }
        if (this.optionSettings() != null) {
            sb.append("OptionSettings: ").append(this.optionSettings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String optionName;
        private Integer port;
        private String optionVersion;
        private List<String> dbSecurityGroupMemberships;
        private List<String> vpcSecurityGroupMemberships;
        private List<OptionSetting> optionSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionConfiguration model) {
            this.setOptionName(model.optionName);
            this.setPort(model.port);
            this.setOptionVersion(model.optionVersion);
            this.setDBSecurityGroupMemberships(model.dbSecurityGroupMemberships);
            this.setVpcSecurityGroupMemberships(model.vpcSecurityGroupMemberships);
            this.setOptionSettings(model.optionSettings);
        }

        public final String getOptionName() {
            return this.optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        public final Integer getPort() {
            return this.port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        public final String getOptionVersion() {
            return this.optionVersion;
        }

        @Override
        public final Builder optionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
            return this;
        }

        public final void setOptionVersion(String optionVersion) {
            this.optionVersion = optionVersion;
        }

        public final Collection<String> getDBSecurityGroupMemberships() {
            return this.dbSecurityGroupMemberships;
        }

        @Override
        public final Builder dbSecurityGroupMemberships(Collection<String> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupNameListCopier.copy(dbSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroupMemberships(String ... dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships(Arrays.asList(dbSecurityGroupMemberships));
            return this;
        }

        public final void setDBSecurityGroupMemberships(Collection<String> dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships = DBSecurityGroupNameListCopier.copy(dbSecurityGroupMemberships);
        }

        @SafeVarargs
        public final void setDBSecurityGroupMemberships(String ... dbSecurityGroupMemberships) {
            this.dbSecurityGroupMemberships(Arrays.asList(dbSecurityGroupMemberships));
        }

        public final Collection<String> getVpcSecurityGroupMemberships() {
            return this.vpcSecurityGroupMemberships;
        }

        @Override
        public final Builder vpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupMemberships(String ... vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships(Arrays.asList(vpcSecurityGroupMemberships));
            return this;
        }

        public final void setVpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupMemberships);
        }

        @SafeVarargs
        public final void setVpcSecurityGroupMemberships(String ... vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships(Arrays.asList(vpcSecurityGroupMemberships));
        }

        public final Collection<OptionSetting> getOptionSettings() {
            return this.optionSettings;
        }

        @Override
        public final Builder optionSettings(Collection<OptionSetting> optionSettings) {
            this.optionSettings = OptionSettingsListCopier.copy(optionSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionSettings(OptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
            return this;
        }

        public final void setOptionSettings(Collection<OptionSetting> optionSettings) {
            this.optionSettings = OptionSettingsListCopier.copy(optionSettings);
        }

        @SafeVarargs
        public final void setOptionSettings(OptionSetting ... optionSettings) {
            this.optionSettings(Arrays.asList(optionSettings));
        }

        public OptionConfiguration build() {
            return new OptionConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionConfiguration> {
        public Builder optionName(String var1);

        public Builder port(Integer var1);

        public Builder optionVersion(String var1);

        public Builder dbSecurityGroupMemberships(Collection<String> var1);

        public Builder dbSecurityGroupMemberships(String ... var1);

        public Builder vpcSecurityGroupMemberships(Collection<String> var1);

        public Builder vpcSecurityGroupMemberships(String ... var1);

        public Builder optionSettings(Collection<OptionSetting> var1);

        public Builder optionSettings(OptionSetting ... var1);
    }
}

