/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.Option;
import software.amazon.awssdk.services.rds.model.OptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OptionGroup
implements ToCopyableBuilder<Builder, OptionGroup> {
    private final String optionGroupName;
    private final String optionGroupDescription;
    private final String engineName;
    private final String majorEngineVersion;
    private final List<Option> options;
    private final Boolean allowsVpcAndNonVpcInstanceMemberships;
    private final String vpcId;
    private final String optionGroupArn;

    private OptionGroup(BuilderImpl builder) {
        this.optionGroupName = builder.optionGroupName;
        this.optionGroupDescription = builder.optionGroupDescription;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.options = builder.options;
        this.allowsVpcAndNonVpcInstanceMemberships = builder.allowsVpcAndNonVpcInstanceMemberships;
        this.vpcId = builder.vpcId;
        this.optionGroupArn = builder.optionGroupArn;
    }

    public String optionGroupName() {
        return this.optionGroupName;
    }

    public String optionGroupDescription() {
        return this.optionGroupDescription;
    }

    public String engineName() {
        return this.engineName;
    }

    public String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public List<Option> options() {
        return this.options;
    }

    public Boolean allowsVpcAndNonVpcInstanceMemberships() {
        return this.allowsVpcAndNonVpcInstanceMemberships;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String optionGroupArn() {
        return this.optionGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.optionGroupName() == null ? 0 : this.optionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupDescription() == null ? 0 : this.optionGroupDescription().hashCode());
        hashCode = 31 * hashCode + (this.engineName() == null ? 0 : this.engineName().hashCode());
        hashCode = 31 * hashCode + (this.majorEngineVersion() == null ? 0 : this.majorEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.options() == null ? 0 : this.options().hashCode());
        hashCode = 31 * hashCode + (this.allowsVpcAndNonVpcInstanceMemberships() == null ? 0 : this.allowsVpcAndNonVpcInstanceMemberships().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        hashCode = 31 * hashCode + (this.optionGroupArn() == null ? 0 : this.optionGroupArn().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroup)) {
            return false;
        }
        OptionGroup other = (OptionGroup)obj;
        if (other.optionGroupName() == null ^ this.optionGroupName() == null) {
            return false;
        }
        if (other.optionGroupName() != null && !other.optionGroupName().equals(this.optionGroupName())) {
            return false;
        }
        if (other.optionGroupDescription() == null ^ this.optionGroupDescription() == null) {
            return false;
        }
        if (other.optionGroupDescription() != null && !other.optionGroupDescription().equals(this.optionGroupDescription())) {
            return false;
        }
        if (other.engineName() == null ^ this.engineName() == null) {
            return false;
        }
        if (other.engineName() != null && !other.engineName().equals(this.engineName())) {
            return false;
        }
        if (other.majorEngineVersion() == null ^ this.majorEngineVersion() == null) {
            return false;
        }
        if (other.majorEngineVersion() != null && !other.majorEngineVersion().equals(this.majorEngineVersion())) {
            return false;
        }
        if (other.options() == null ^ this.options() == null) {
            return false;
        }
        if (other.options() != null && !other.options().equals(this.options())) {
            return false;
        }
        if (other.allowsVpcAndNonVpcInstanceMemberships() == null ^ this.allowsVpcAndNonVpcInstanceMemberships() == null) {
            return false;
        }
        if (other.allowsVpcAndNonVpcInstanceMemberships() != null && !other.allowsVpcAndNonVpcInstanceMemberships().equals(this.allowsVpcAndNonVpcInstanceMemberships())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.optionGroupArn() == null ^ this.optionGroupArn() == null) {
            return false;
        }
        return other.optionGroupArn() == null || other.optionGroupArn().equals(this.optionGroupArn());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.optionGroupName() != null) {
            sb.append("OptionGroupName: ").append(this.optionGroupName()).append(",");
        }
        if (this.optionGroupDescription() != null) {
            sb.append("OptionGroupDescription: ").append(this.optionGroupDescription()).append(",");
        }
        if (this.engineName() != null) {
            sb.append("EngineName: ").append(this.engineName()).append(",");
        }
        if (this.majorEngineVersion() != null) {
            sb.append("MajorEngineVersion: ").append(this.majorEngineVersion()).append(",");
        }
        if (this.options() != null) {
            sb.append("Options: ").append(this.options()).append(",");
        }
        if (this.allowsVpcAndNonVpcInstanceMemberships() != null) {
            sb.append("AllowsVpcAndNonVpcInstanceMemberships: ").append(this.allowsVpcAndNonVpcInstanceMemberships()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        if (this.optionGroupArn() != null) {
            sb.append("OptionGroupArn: ").append(this.optionGroupArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String optionGroupName;
        private String optionGroupDescription;
        private String engineName;
        private String majorEngineVersion;
        private List<Option> options;
        private Boolean allowsVpcAndNonVpcInstanceMemberships;
        private String vpcId;
        private String optionGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroup model) {
            this.setOptionGroupName(model.optionGroupName);
            this.setOptionGroupDescription(model.optionGroupDescription);
            this.setEngineName(model.engineName);
            this.setMajorEngineVersion(model.majorEngineVersion);
            this.setOptions(model.options);
            this.setAllowsVpcAndNonVpcInstanceMemberships(model.allowsVpcAndNonVpcInstanceMemberships);
            this.setVpcId(model.vpcId);
            this.setOptionGroupArn(model.optionGroupArn);
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        public final String getOptionGroupDescription() {
            return this.optionGroupDescription;
        }

        @Override
        public final Builder optionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
            return this;
        }

        public final void setOptionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        public final Collection<Option> getOptions() {
            return this.options;
        }

        @Override
        public final Builder options(Collection<Option> options) {
            this.options = OptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Option ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        public final void setOptions(Collection<Option> options) {
            this.options = OptionsListCopier.copy(options);
        }

        @SafeVarargs
        public final void setOptions(Option ... options) {
            this.options(Arrays.asList(options));
        }

        public final Boolean getAllowsVpcAndNonVpcInstanceMemberships() {
            return this.allowsVpcAndNonVpcInstanceMemberships;
        }

        @Override
        public final Builder allowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
            this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
            return this;
        }

        public final void setAllowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
            this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getOptionGroupArn() {
            return this.optionGroupArn;
        }

        @Override
        public final Builder optionGroupArn(String optionGroupArn) {
            this.optionGroupArn = optionGroupArn;
            return this;
        }

        public final void setOptionGroupArn(String optionGroupArn) {
            this.optionGroupArn = optionGroupArn;
        }

        public OptionGroup build() {
            return new OptionGroup(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionGroup> {
        public Builder optionGroupName(String var1);

        public Builder optionGroupDescription(String var1);

        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder options(Collection<Option> var1);

        public Builder options(Option ... var1);

        public Builder allowsVpcAndNonVpcInstanceMemberships(Boolean var1);

        public Builder vpcId(String var1);

        public Builder optionGroupArn(String var1);
    }
}

