/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.services.rds.model.RecurringCharge;
import software.amazon.awssdk.services.rds.model.RecurringChargeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ReservedDBInstancesOffering
implements ToCopyableBuilder<Builder, ReservedDBInstancesOffering> {
    private final String reservedDBInstancesOfferingId;
    private final String dbInstanceClass;
    private final Integer duration;
    private final Double fixedPrice;
    private final Double usagePrice;
    private final String currencyCode;
    private final String productDescription;
    private final String offeringType;
    private final Boolean multiAZ;
    private final List<RecurringCharge> recurringCharges;

    private ReservedDBInstancesOffering(BuilderImpl builder) {
        this.reservedDBInstancesOfferingId = builder.reservedDBInstancesOfferingId;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.duration = builder.duration;
        this.fixedPrice = builder.fixedPrice;
        this.usagePrice = builder.usagePrice;
        this.currencyCode = builder.currencyCode;
        this.productDescription = builder.productDescription;
        this.offeringType = builder.offeringType;
        this.multiAZ = builder.multiAZ;
        this.recurringCharges = builder.recurringCharges;
    }

    public String reservedDBInstancesOfferingId() {
        return this.reservedDBInstancesOfferingId;
    }

    public String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public Integer duration() {
        return this.duration;
    }

    public Double fixedPrice() {
        return this.fixedPrice;
    }

    public Double usagePrice() {
        return this.usagePrice;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public String productDescription() {
        return this.productDescription;
    }

    public String offeringType() {
        return this.offeringType;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public List<RecurringCharge> recurringCharges() {
        return this.recurringCharges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.reservedDBInstancesOfferingId() == null ? 0 : this.reservedDBInstancesOfferingId().hashCode());
        hashCode = 31 * hashCode + (this.dbInstanceClass() == null ? 0 : this.dbInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.duration() == null ? 0 : this.duration().hashCode());
        hashCode = 31 * hashCode + (this.fixedPrice() == null ? 0 : this.fixedPrice().hashCode());
        hashCode = 31 * hashCode + (this.usagePrice() == null ? 0 : this.usagePrice().hashCode());
        hashCode = 31 * hashCode + (this.currencyCode() == null ? 0 : this.currencyCode().hashCode());
        hashCode = 31 * hashCode + (this.productDescription() == null ? 0 : this.productDescription().hashCode());
        hashCode = 31 * hashCode + (this.offeringType() == null ? 0 : this.offeringType().hashCode());
        hashCode = 31 * hashCode + (this.multiAZ() == null ? 0 : this.multiAZ().hashCode());
        hashCode = 31 * hashCode + (this.recurringCharges() == null ? 0 : this.recurringCharges().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedDBInstancesOffering)) {
            return false;
        }
        ReservedDBInstancesOffering other = (ReservedDBInstancesOffering)obj;
        if (other.reservedDBInstancesOfferingId() == null ^ this.reservedDBInstancesOfferingId() == null) {
            return false;
        }
        if (other.reservedDBInstancesOfferingId() != null && !other.reservedDBInstancesOfferingId().equals(this.reservedDBInstancesOfferingId())) {
            return false;
        }
        if (other.dbInstanceClass() == null ^ this.dbInstanceClass() == null) {
            return false;
        }
        if (other.dbInstanceClass() != null && !other.dbInstanceClass().equals(this.dbInstanceClass())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.fixedPrice() == null ^ this.fixedPrice() == null) {
            return false;
        }
        if (other.fixedPrice() != null && !other.fixedPrice().equals(this.fixedPrice())) {
            return false;
        }
        if (other.usagePrice() == null ^ this.usagePrice() == null) {
            return false;
        }
        if (other.usagePrice() != null && !other.usagePrice().equals(this.usagePrice())) {
            return false;
        }
        if (other.currencyCode() == null ^ this.currencyCode() == null) {
            return false;
        }
        if (other.currencyCode() != null && !other.currencyCode().equals(this.currencyCode())) {
            return false;
        }
        if (other.productDescription() == null ^ this.productDescription() == null) {
            return false;
        }
        if (other.productDescription() != null && !other.productDescription().equals(this.productDescription())) {
            return false;
        }
        if (other.offeringType() == null ^ this.offeringType() == null) {
            return false;
        }
        if (other.offeringType() != null && !other.offeringType().equals(this.offeringType())) {
            return false;
        }
        if (other.multiAZ() == null ^ this.multiAZ() == null) {
            return false;
        }
        if (other.multiAZ() != null && !other.multiAZ().equals(this.multiAZ())) {
            return false;
        }
        if (other.recurringCharges() == null ^ this.recurringCharges() == null) {
            return false;
        }
        return other.recurringCharges() == null || other.recurringCharges().equals(this.recurringCharges());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.reservedDBInstancesOfferingId() != null) {
            sb.append("ReservedDBInstancesOfferingId: ").append(this.reservedDBInstancesOfferingId()).append(",");
        }
        if (this.dbInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.dbInstanceClass()).append(",");
        }
        if (this.duration() != null) {
            sb.append("Duration: ").append(this.duration()).append(",");
        }
        if (this.fixedPrice() != null) {
            sb.append("FixedPrice: ").append(this.fixedPrice()).append(",");
        }
        if (this.usagePrice() != null) {
            sb.append("UsagePrice: ").append(this.usagePrice()).append(",");
        }
        if (this.currencyCode() != null) {
            sb.append("CurrencyCode: ").append(this.currencyCode()).append(",");
        }
        if (this.productDescription() != null) {
            sb.append("ProductDescription: ").append(this.productDescription()).append(",");
        }
        if (this.offeringType() != null) {
            sb.append("OfferingType: ").append(this.offeringType()).append(",");
        }
        if (this.multiAZ() != null) {
            sb.append("MultiAZ: ").append(this.multiAZ()).append(",");
        }
        if (this.recurringCharges() != null) {
            sb.append("RecurringCharges: ").append(this.recurringCharges()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String reservedDBInstancesOfferingId;
        private String dbInstanceClass;
        private Integer duration;
        private Double fixedPrice;
        private Double usagePrice;
        private String currencyCode;
        private String productDescription;
        private String offeringType;
        private Boolean multiAZ;
        private List<RecurringCharge> recurringCharges;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedDBInstancesOffering model) {
            this.setReservedDBInstancesOfferingId(model.reservedDBInstancesOfferingId);
            this.setDBInstanceClass(model.dbInstanceClass);
            this.setDuration(model.duration);
            this.setFixedPrice(model.fixedPrice);
            this.setUsagePrice(model.usagePrice);
            this.setCurrencyCode(model.currencyCode);
            this.setProductDescription(model.productDescription);
            this.setOfferingType(model.offeringType);
            this.setMultiAZ(model.multiAZ);
            this.setRecurringCharges(model.recurringCharges);
        }

        public final String getReservedDBInstancesOfferingId() {
            return this.reservedDBInstancesOfferingId;
        }

        @Override
        public final Builder reservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
            return this;
        }

        public final void setReservedDBInstancesOfferingId(String reservedDBInstancesOfferingId) {
            this.reservedDBInstancesOfferingId = reservedDBInstancesOfferingId;
        }

        public final String getDBInstanceClass() {
            return this.dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final void setDBInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        @Override
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        @Override
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        @Override
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        @Override
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final Collection<RecurringCharge> getRecurringCharges() {
            return this.recurringCharges;
        }

        @Override
        public final Builder recurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
            return this;
        }

        public final void setRecurringCharges(Collection<RecurringCharge> recurringCharges) {
            this.recurringCharges = RecurringChargeListCopier.copy(recurringCharges);
        }

        @SafeVarargs
        public final void setRecurringCharges(RecurringCharge ... recurringCharges) {
            this.recurringCharges(Arrays.asList(recurringCharges));
        }

        public ReservedDBInstancesOffering build() {
            return new ReservedDBInstancesOffering(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ReservedDBInstancesOffering> {
        public Builder reservedDBInstancesOfferingId(String var1);

        public Builder dbInstanceClass(String var1);

        public Builder duration(Integer var1);

        public Builder fixedPrice(Double var1);

        public Builder usagePrice(Double var1);

        public Builder currencyCode(String var1);

        public Builder productDescription(String var1);

        public Builder offeringType(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder recurringCharges(Collection<RecurringCharge> var1);

        public Builder recurringCharges(RecurringCharge ... var1);
    }
}

