/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.AccountQuota;

public class AccountQuotaUnmarshaller
implements Unmarshaller<AccountQuota, StaxUnmarshallerContext> {
    private static AccountQuotaUnmarshaller INSTANCE;

    public AccountQuota unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        AccountQuota.Builder accountQuota = AccountQuota.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AccountQuotaName", targetDepth)) {
                    accountQuota.accountQuotaName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Used", targetDepth)) {
                    accountQuota.used(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Max", targetDepth)) continue;
                accountQuota.max(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (AccountQuota)accountQuota.build();
    }

    public static AccountQuotaUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AccountQuotaUnmarshaller();
        }
        return INSTANCE;
    }
}

