/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.rds.model.DBClusterMember;

public class DBClusterMemberUnmarshaller
implements Unmarshaller<DBClusterMember, StaxUnmarshallerContext> {
    private static DBClusterMemberUnmarshaller INSTANCE;

    public DBClusterMember unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DBClusterMember.Builder dbClusterMember = DBClusterMember.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DBInstanceIdentifier", targetDepth)) {
                    dbClusterMember.dbInstanceIdentifier(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IsClusterWriter", targetDepth)) {
                    dbClusterMember.isClusterWriter(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DBClusterParameterGroupStatus", targetDepth)) {
                    dbClusterMember.dbClusterParameterGroupStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("PromotionTier", targetDepth)) continue;
                dbClusterMember.promotionTier(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DBClusterMember)dbClusterMember.build();
    }

    public static DBClusterMemberUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DBClusterMemberUnmarshaller();
        }
        return INSTANCE;
    }
}

