/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.rds.model.RevokeDBSecurityGroupIngressRequest;
import software.amazon.awssdk.util.StringUtils;

public class RevokeDBSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<RevokeDBSecurityGroupIngressRequest>, RevokeDBSecurityGroupIngressRequest> {
    public Request<RevokeDBSecurityGroupIngressRequest> marshall(RevokeDBSecurityGroupIngressRequest revokeDBSecurityGroupIngressRequest) {
        if (revokeDBSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)revokeDBSecurityGroupIngressRequest, "RDSClient");
        request.addParameter("Action", "RevokeDBSecurityGroupIngress");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeDBSecurityGroupIngressRequest.dbSecurityGroupName() != null) {
            request.addParameter("DBSecurityGroupName", StringUtils.fromString((String)revokeDBSecurityGroupIngressRequest.dbSecurityGroupName()));
        }
        if (revokeDBSecurityGroupIngressRequest.cidrip() != null) {
            request.addParameter("CIDRIP", StringUtils.fromString((String)revokeDBSecurityGroupIngressRequest.cidrip()));
        }
        if (revokeDBSecurityGroupIngressRequest.ec2SecurityGroupName() != null) {
            request.addParameter("EC2SecurityGroupName", StringUtils.fromString((String)revokeDBSecurityGroupIngressRequest.ec2SecurityGroupName()));
        }
        if (revokeDBSecurityGroupIngressRequest.ec2SecurityGroupId() != null) {
            request.addParameter("EC2SecurityGroupId", StringUtils.fromString((String)revokeDBSecurityGroupIngressRequest.ec2SecurityGroupId()));
        }
        if (revokeDBSecurityGroupIngressRequest.ec2SecurityGroupOwnerId() != null) {
            request.addParameter("EC2SecurityGroupOwnerId", StringUtils.fromString((String)revokeDBSecurityGroupIngressRequest.ec2SecurityGroupOwnerId()));
        }
        return request;
    }
}

